/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.sedalib.core.seda;

public enum SedaVersion {
    V2_0(2, 0),
    V2_1(2, 1),
    V2_2(2, 2),
    V2_3(2, 3);

    private final int major;
    private final int minor;

    private SedaVersion(int major, int minor) {
        this.major = major;
        this.minor = minor;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public String toString() {
        return this.major + "." + this.minor;
    }

    public String displayString() {
        return "SEDA " + this.major + "." + this.minor;
    }

    public static SedaVersion from(int major, int minor) {
        for (SedaVersion version2 : SedaVersion.values()) {
            if (version2.major != major || version2.minor != minor) continue;
            return version2;
        }
        throw new IllegalArgumentException("Unsupported SEDA version: " + major + "." + minor);
    }

    public static SedaVersion from(String version2) {
        String[] fragments = version2.split("[.]");
        int major = 2;
        if (fragments.length == 1) {
            int minor = Integer.parseInt(fragments[0]);
            return SedaVersion.from(major, minor);
        }
        if (fragments.length == 2) {
            major = Integer.parseInt(fragments[0]);
            int minor = Integer.parseInt(fragments[1]);
            return SedaVersion.from(major, minor);
        }
        throw new IllegalArgumentException("Unsupported SEDA version: " + version2);
    }
}

