/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.sedalib.core.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import fr.gouv.vitam.tools.sedalib.core.DataObjectPackage;
import java.io.IOException;
import java.util.Arrays;
import java.util.Set;

public class DataObjectPackageSerializer
extends StdSerializer<DataObjectPackage> {
    private static final long serialVersionUID = -2569548330768460458L;

    public DataObjectPackageSerializer() {
        this((Class<DataObjectPackage>)null);
    }

    public DataObjectPackageSerializer(Class<DataObjectPackage> t) {
        super(t);
    }

    @Override
    public void serialize(DataObjectPackage dataObjectPackage, JsonGenerator jGen, SerializerProvider serializerProvider) throws IOException {
        jGen.disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
        jGen.writeStartObject();
        jGen.writeArrayFieldStart("dataObjectGroupList");
        Set<String> sog = dataObjectPackage.getDogInDataObjectPackageIdMap().keySet();
        Object[] tempArray = sog.toArray(new String[0]);
        Arrays.sort(tempArray);
        for (Object s : tempArray) {
            jGen.writeObject(dataObjectPackage.getDogInDataObjectPackageIdMap().get(s));
        }
        jGen.writeEndArray();
        jGen.writeArrayFieldStart("ArchiveUnitList");
        Set<String> sau = dataObjectPackage.getAuInDataObjectPackageIdMap().keySet();
        tempArray = sau.toArray(new String[0]);
        Arrays.sort(tempArray);
        for (Object s : tempArray) {
            jGen.writeObject(dataObjectPackage.getAuInDataObjectPackageIdMap().get(s));
        }
        jGen.writeEndArray();
        jGen.writeObjectField("ghostRootAu", dataObjectPackage.getGhostRootAu());
        jGen.writeObjectField("vitamNormalizationStatus", dataObjectPackage.getVitamNormalizationStatus());
        jGen.writeEndObject();
    }
}

