/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.sedalib.core.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import fr.gouv.vitam.tools.sedalib.core.ArchiveUnit;
import fr.gouv.vitam.tools.sedalib.core.BinaryDataObject;
import fr.gouv.vitam.tools.sedalib.core.DataObjectGroup;
import fr.gouv.vitam.tools.sedalib.core.DataObjectPackage;
import fr.gouv.vitam.tools.sedalib.core.PhysicalDataObject;
import fr.gouv.vitam.tools.sedalib.utils.SEDALibException;
import fr.gouv.vitam.tools.sedalib.utils.SEDALibJsonProcessingException;
import java.io.IOException;

public class DataObjectPackageDeserializer
extends StdDeserializer<DataObjectPackage> {
    private static final long serialVersionUID = -2569548330768460468L;

    public DataObjectPackageDeserializer() {
        this((Class<DataObjectPackage>)null);
    }

    public DataObjectPackageDeserializer(Class<DataObjectPackage> t) {
        super(t);
    }

    @Override
    public DataObjectPackage deserialize(JsonParser parser2, DeserializationContext deserializer) throws IOException {
        DataObjectPackage dataObjectPackage = new DataObjectPackage();
        parser2.disable(JsonParser.Feature.AUTO_CLOSE_SOURCE);
        try {
            while (parser2.nextToken() != JsonToken.END_OBJECT) {
                String fieldname = parser2.getCurrentName();
                parser2.nextToken();
                switch (fieldname) {
                    case "dataObjectGroupList": {
                        while (parser2.nextToken() != JsonToken.END_ARRAY) {
                            DataObjectGroup og = parser2.readValueAs(DataObjectGroup.class);
                            dataObjectPackage.addDataObjectGroup(og);
                            for (BinaryDataObject bdo : og.getBinaryDataObjectList()) {
                                dataObjectPackage.addDataObjectPackageIdElement(bdo);
                            }
                            for (PhysicalDataObject pdo : og.getPhysicalDataObjectList()) {
                                dataObjectPackage.addDataObjectPackageIdElement(pdo);
                            }
                        }
                        break;
                    }
                    case "ArchiveUnitList": {
                        ArchiveUnit au;
                        while (parser2.nextToken() != JsonToken.END_ARRAY) {
                            au = parser2.readValueAs(ArchiveUnit.class);
                            dataObjectPackage.addArchiveUnit(au);
                        }
                        break;
                    }
                    case "ghostRootAu": {
                        ArchiveUnit au = parser2.readValueAs(ArchiveUnit.class);
                        dataObjectPackage.setGhostRootAu(au);
                        break;
                    }
                    case "vitamNormalizationStatus": {
                        int status = parser2.readValueAs(Integer.class);
                        dataObjectPackage.setVitamNormalizationStatus(status);
                        break;
                    }
                }
            }
        }
        catch (SEDALibException e) {
            throw new SEDALibJsonProcessingException("Erreur dans la deserialisation de l'ArchiveTransfer\n->" + e.getMessage());
        }
        return dataObjectPackage;
    }
}

