/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.sedalib.core;

import com.fasterxml.jackson.annotation.JsonIgnore;
import fr.gouv.vitam.tools.sedalib.core.AbstractUnitaryDataObject;
import fr.gouv.vitam.tools.sedalib.core.DataObject;
import fr.gouv.vitam.tools.sedalib.core.DataObjectPackage;
import fr.gouv.vitam.tools.sedalib.core.seda.SedaVersion;
import fr.gouv.vitam.tools.sedalib.metadata.content.PersistentIdentifier;
import fr.gouv.vitam.tools.sedalib.metadata.data.PhysicalDimensions;
import fr.gouv.vitam.tools.sedalib.metadata.data.Relationship;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.ComplexListInterface;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.ComplexListMetadataKind;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.ComplexListMetadataMap;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.IntegerType;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.StringType;
import fr.gouv.vitam.tools.sedalib.utils.SEDALibException;
import fr.gouv.vitam.tools.sedalib.utils.SEDALibProgressLogger;
import fr.gouv.vitam.tools.sedalib.xml.SEDAXMLEventReader;
import java.util.LinkedHashMap;
import java.util.Map;

public class PhysicalDataObject
extends AbstractUnitaryDataObject
implements DataObject,
ComplexListInterface {
    @ComplexListMetadataMap(isExpandable=true, sedaVersion={SedaVersion.V2_1})
    public static final Map<String, ComplexListMetadataKind> METADATA_MAP_V1 = new LinkedHashMap<String, ComplexListMetadataKind>();
    @ComplexListMetadataMap(isExpandable=true, sedaVersion={SedaVersion.V2_2})
    public static final Map<String, ComplexListMetadataKind> METADATA_MAP_V2;
    @ComplexListMetadataMap(isExpandable=true, sedaVersion={SedaVersion.V2_3})
    public static final Map<String, ComplexListMetadataKind> METADATA_MAP_V3;

    @Override
    @JsonIgnore
    public LinkedHashMap<String, ComplexListMetadataKind> getMetadataMap() throws SEDALibException {
        return (LinkedHashMap)ComplexListInterface.getMetadataMap(this.getClass());
    }

    @Override
    @JsonIgnore
    public boolean isNotExpandable() {
        return ComplexListInterface.isNotExpandable(this.getClass());
    }

    public PhysicalDataObject() {
        this(null);
    }

    public PhysicalDataObject(DataObjectPackage dataObjectPackage) {
        super(dataObjectPackage);
    }

    public PhysicalDataObject(DataObjectPackage dataObjectPackage, String xmlData) throws SEDALibException {
        this(dataObjectPackage);
        this.fromSedaXmlFragments(xmlData);
    }

    public static PhysicalDataObject fromSedaXml(SEDAXMLEventReader xmlReader, DataObjectPackage dataObjectPackage, SEDALibProgressLogger sedaLibProgressLogger) throws SEDALibException, InterruptedException {
        PhysicalDataObject pdo = new PhysicalDataObject();
        return PhysicalDataObject.importUnitaryDataObjectPackageIdElementFromSedaXml(pdo, xmlReader, dataObjectPackage, sedaLibProgressLogger) ? pdo : null;
    }

    static {
        METADATA_MAP_V1.put("DataObjectSystemId", new ComplexListMetadataKind(StringType.class, false));
        METADATA_MAP_V1.put("DataObjectGroupSystemId", new ComplexListMetadataKind(StringType.class, false));
        METADATA_MAP_V1.put("Relationship", new ComplexListMetadataKind(Relationship.class, true));
        METADATA_MAP_V1.put("DataObjectGroupReferenceId", new ComplexListMetadataKind(StringType.class, false));
        METADATA_MAP_V1.put("DataObjectGroupId", new ComplexListMetadataKind(StringType.class, false));
        METADATA_MAP_V1.put("DataObjectVersion", new ComplexListMetadataKind(StringType.class, false));
        METADATA_MAP_V1.put("PhysicalId", new ComplexListMetadataKind(StringType.class, false));
        METADATA_MAP_V1.put("PhysicalDimensions", new ComplexListMetadataKind(PhysicalDimensions.class, false));
        METADATA_MAP_V2 = new LinkedHashMap<String, ComplexListMetadataKind>();
        METADATA_MAP_V2.put("DataObjectProfile", new ComplexListMetadataKind(StringType.class, false));
        METADATA_MAP_V2.put("DataObjectSystemId", new ComplexListMetadataKind(StringType.class, false));
        METADATA_MAP_V2.put("DataObjectGroupSystemId", new ComplexListMetadataKind(StringType.class, false));
        METADATA_MAP_V2.put("Relationship", new ComplexListMetadataKind(Relationship.class, true));
        METADATA_MAP_V2.put("DataObjectVersion", new ComplexListMetadataKind(StringType.class, false));
        METADATA_MAP_V2.put("PhysicalId", new ComplexListMetadataKind(StringType.class, false));
        METADATA_MAP_V2.put("PhysicalDimensions", new ComplexListMetadataKind(PhysicalDimensions.class, false));
        METADATA_MAP_V3 = new LinkedHashMap<String, ComplexListMetadataKind>();
        METADATA_MAP_V3.put("DataObjectProfile", new ComplexListMetadataKind(StringType.class, false));
        METADATA_MAP_V3.put("DataObjectSystemId", new ComplexListMetadataKind(StringType.class, false));
        METADATA_MAP_V3.put("DataObjectGroupSystemId", new ComplexListMetadataKind(StringType.class, false));
        METADATA_MAP_V3.put("Relationship", new ComplexListMetadataKind(Relationship.class, true));
        METADATA_MAP_V3.put("DataObjectVersion", new ComplexListMetadataKind(StringType.class, false));
        METADATA_MAP_V3.put("PersistentIdentifier", new ComplexListMetadataKind(PersistentIdentifier.class, true));
        METADATA_MAP_V3.put("DataObjectUse", new ComplexListMetadataKind(StringType.class, false));
        METADATA_MAP_V3.put("DataObjectNumber", new ComplexListMetadataKind(IntegerType.class, false));
        METADATA_MAP_V3.put("PhysicalId", new ComplexListMetadataKind(StringType.class, false));
        METADATA_MAP_V3.put("PhysicalDimensions", new ComplexListMetadataKind(PhysicalDimensions.class, false));
    }
}

