/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.sedalib.core;

import fr.gouv.vitam.tools.sedalib.utils.SEDALibException;
import fr.gouv.vitam.tools.sedalib.xml.SEDAXMLEventReader;
import fr.gouv.vitam.tools.sedalib.xml.SEDAXMLStreamWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public class GlobalMetadata {
    public String comment;
    public String date;
    public boolean nowFlag;
    public String messageIdentifier;
    public String archivalAgreement;
    public String codeListVersionsXmlData;
    public String transferRequestReplyIdentifier;
    public String archivalAgencyIdentifier;
    public String archivalAgencyOrganizationDescriptiveMetadataXmlData;
    public String transferringAgencyIdentifier;
    public String transferringAgencyOrganizationDescriptiveMetadataXmlData;

    public GlobalMetadata() {
        this.comment = null;
        this.date = null;
        this.nowFlag = true;
        this.messageIdentifier = null;
        this.archivalAgreement = null;
        this.codeListVersionsXmlData = null;
        this.transferRequestReplyIdentifier = null;
        this.archivalAgencyIdentifier = null;
        this.archivalAgencyOrganizationDescriptiveMetadataXmlData = null;
        this.transferringAgencyIdentifier = null;
        this.transferringAgencyOrganizationDescriptiveMetadataXmlData = null;
    }

    public GlobalMetadata(GlobalMetadata globalMetadata) {
        this.comment = globalMetadata.comment;
        this.date = globalMetadata.date;
        this.nowFlag = globalMetadata.nowFlag;
        this.messageIdentifier = globalMetadata.messageIdentifier;
        this.archivalAgreement = globalMetadata.archivalAgreement;
        this.codeListVersionsXmlData = globalMetadata.codeListVersionsXmlData;
        this.transferRequestReplyIdentifier = globalMetadata.transferRequestReplyIdentifier;
        this.archivalAgencyIdentifier = globalMetadata.archivalAgencyIdentifier;
        this.archivalAgencyOrganizationDescriptiveMetadataXmlData = globalMetadata.archivalAgencyOrganizationDescriptiveMetadataXmlData;
        this.transferringAgencyIdentifier = globalMetadata.transferringAgencyIdentifier;
        this.transferringAgencyOrganizationDescriptiveMetadataXmlData = globalMetadata.transferringAgencyOrganizationDescriptiveMetadataXmlData;
    }

    public String toSedaXmlFragments() throws SEDALibException {
        String result;
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
             SEDAXMLStreamWriter xmlWriter = new SEDAXMLStreamWriter(baos, 2, true);){
            xmlWriter.writeElementValueIfNotEmpty("Comment", this.comment);
            if (!this.isNowFlag()) {
                xmlWriter.writeElementValueIfNotEmpty("Date", this.date);
            }
            xmlWriter.writeElementValueIfNotEmpty("MessageIdentifier", this.messageIdentifier);
            xmlWriter.writeElementValueIfNotEmpty("ArchivalAgreement", this.archivalAgreement);
            xmlWriter.writeRawXMLBlockIfNotEmpty(this.codeListVersionsXmlData);
            xmlWriter.writeElementValueIfNotEmpty("TransferRequestReplyIdentifier", this.transferRequestReplyIdentifier);
            xmlWriter.writeStartElement("ArchivalAgency");
            xmlWriter.writeElementValue("Identifier", this.archivalAgencyIdentifier);
            xmlWriter.writeRawXMLBlockIfNotEmpty(this.archivalAgencyOrganizationDescriptiveMetadataXmlData);
            xmlWriter.writeEndElement();
            xmlWriter.writeStartElement("TransferringAgency");
            xmlWriter.writeElementValue("Identifier", this.transferringAgencyIdentifier);
            xmlWriter.writeRawXMLBlockIfNotEmpty(this.transferringAgencyOrganizationDescriptiveMetadataXmlData);
            xmlWriter.writeEndElement();
            xmlWriter.close();
            result = baos.toString(StandardCharsets.UTF_8);
        }
        catch (SEDALibException | IOException | XMLStreamException e) {
            throw new SEDALibException("Erreur interne", e);
        }
        return result;
    }

    private void setFromXmlContent(SEDAXMLEventReader xmlReader) throws SEDALibException {
        try {
            this.comment = xmlReader.nextValueIfNamed("Comment");
            this.date = xmlReader.nextValueIfNamed("Date");
            this.nowFlag = this.date == null;
            this.messageIdentifier = xmlReader.nextValueIfNamed("MessageIdentifier");
            this.archivalAgreement = xmlReader.nextValueIfNamed("ArchivalAgreement");
            this.codeListVersionsXmlData = xmlReader.nextBlockAsStringIfNamed("CodeListVersions");
            this.transferRequestReplyIdentifier = xmlReader.nextValueIfNamed("TransferRequestReplyIdentifier");
            if (xmlReader.nextBlockIfNamed("ArchivalAgency")) {
                this.archivalAgencyIdentifier = xmlReader.nextValueIfNamed("Identifier");
                this.archivalAgencyOrganizationDescriptiveMetadataXmlData = xmlReader.nextBlockAsStringIfNamed("OrganizationDescriptiveMetadata");
                xmlReader.endBlockNamed("ArchivalAgency");
            }
            if (xmlReader.nextBlockIfNamed("TransferringAgency")) {
                this.transferringAgencyIdentifier = xmlReader.nextValueIfNamed("Identifier");
                this.transferringAgencyOrganizationDescriptiveMetadataXmlData = xmlReader.nextBlockAsStringIfNamed("OrganizationDescriptiveMetadata");
                xmlReader.endBlockNamed("TransferringAgency");
            }
        }
        catch (XMLStreamException e) {
            throw new SEDALibException("Erreur de lecture XML", e);
        }
    }

    public void fromSedaXmlFragments(String fragments) throws SEDALibException {
        GlobalMetadata gm = new GlobalMetadata();
        try (ByteArrayInputStream bais = new ByteArrayInputStream(fragments.getBytes(StandardCharsets.UTF_8));
             SEDAXMLEventReader xmlReader = new SEDAXMLEventReader(bais, true);){
            xmlReader.nextUsefullEvent();
            gm.setFromXmlContent(xmlReader);
            XMLEvent event = xmlReader.xmlReader.peek();
            if (!event.isEndDocument()) {
                throw new SEDALibException("Il y a des champs ill\u00e9gaux");
            }
        }
        catch (SEDALibException | IOException | XMLStreamException e) {
            throw new SEDALibException("Erreur de lecture du GlobalMetadata", e);
        }
        this.comment = gm.comment;
        this.date = gm.date;
        this.nowFlag = gm.nowFlag;
        this.messageIdentifier = gm.messageIdentifier;
        this.archivalAgreement = gm.archivalAgreement;
        this.codeListVersionsXmlData = gm.codeListVersionsXmlData;
        this.transferRequestReplyIdentifier = gm.transferRequestReplyIdentifier;
        this.archivalAgencyIdentifier = gm.archivalAgencyIdentifier;
        this.archivalAgencyOrganizationDescriptiveMetadataXmlData = gm.archivalAgencyOrganizationDescriptiveMetadataXmlData;
        this.transferringAgencyIdentifier = gm.transferringAgencyIdentifier;
        this.transferringAgencyOrganizationDescriptiveMetadataXmlData = gm.transferringAgencyOrganizationDescriptiveMetadataXmlData;
    }

    public boolean isNowFlag() {
        return this.nowFlag;
    }

    public void setNowFlag(boolean nowFlag) {
        this.nowFlag = nowFlag;
    }
}

