/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.sedalib.core;

import com.fasterxml.jackson.annotation.JsonIgnore;
import fr.gouv.vitam.tools.sedalib.core.DataObject;
import fr.gouv.vitam.tools.sedalib.core.DataObjectGroup;
import fr.gouv.vitam.tools.sedalib.core.DataObjectPackage;
import fr.gouv.vitam.tools.sedalib.core.DataObjectPackageElement;
import java.util.ArrayList;
import java.util.List;

public class DataObjectRefList
extends DataObjectPackageElement {
    @JsonIgnore
    private List<DataObject> dataObjectList;
    private ArrayList<String> inDataObjectPackageIdList = null;

    public DataObjectRefList() {
        this(null);
    }

    public DataObjectRefList(DataObjectPackage dataObjectPackage) {
        super(dataObjectPackage);
    }

    public ArrayList<String> getInDataObjectPackageIdList() {
        if (this.inDataObjectPackageIdList != null) {
            return this.inDataObjectPackageIdList;
        }
        if (this.dataObjectList == null) {
            this.inDataObjectPackageIdList = new ArrayList(0);
        } else {
            this.inDataObjectPackageIdList = new ArrayList(this.dataObjectList.size());
            for (DataObject dataObject : this.dataObjectList) {
                this.inDataObjectPackageIdList.add(dataObject.getInDataObjectPackageId());
            }
        }
        this.dataObjectList = null;
        return this.inDataObjectPackageIdList;
    }

    public void setInDataObjectPackageIdList(ArrayList<String> inDataObjectPackageIdList) {
        this.inDataObjectPackageIdList = inDataObjectPackageIdList;
        this.dataObjectList = null;
    }

    public List<DataObject> getDataObjectList() {
        if (this.dataObjectList != null) {
            return this.dataObjectList;
        }
        if (this.inDataObjectPackageIdList == null) {
            this.dataObjectList = new ArrayList<DataObject>(0);
        } else {
            this.dataObjectList = new ArrayList<DataObject>(this.inDataObjectPackageIdList.size());
            for (String inSipId : this.inDataObjectPackageIdList) {
                this.dataObjectList.add(this.getDataObjectPackage().getDataObjectById(inSipId));
            }
        }
        this.inDataObjectPackageIdList = null;
        return this.dataObjectList;
    }

    public void setDataObjectList(List<DataObject> dataObjectList) {
        this.dataObjectList = dataObjectList;
        this.inDataObjectPackageIdList = null;
    }

    public void add(DataObject zdo) {
        this.getDataObjectList().add(zdo);
    }

    public void addById(String inDataObjectPackageId) {
        this.getInDataObjectPackageIdList().add(inDataObjectPackageId);
    }

    public void remove(DataObject zdo) {
        this.getDataObjectList().remove(zdo);
    }

    public void removeById(String inDataObjectPackageId) {
        this.getInDataObjectPackageIdList().remove(inDataObjectPackageId);
    }

    @JsonIgnore
    public int getCount() {
        if (this.inDataObjectPackageIdList != null) {
            return this.inDataObjectPackageIdList.size();
        }
        if (this.dataObjectList != null) {
            return this.dataObjectList.size();
        }
        return 0;
    }

    @JsonIgnore
    public DataObjectGroup getNormalizedDataObjectGroup() {
        this.getDataObjectList();
        if (this.dataObjectList.size() != 1) {
            return null;
        }
        if (this.dataObjectList.get(0) instanceof DataObjectGroup) {
            return (DataObjectGroup)this.dataObjectList.get(0);
        }
        return null;
    }
}

