/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.sedalib.core;

import fr.gouv.vitam.tools.sedalib.core.ArchiveUnit;
import fr.gouv.vitam.tools.sedalib.core.BinaryDataObject;
import fr.gouv.vitam.tools.sedalib.core.DataObject;
import fr.gouv.vitam.tools.sedalib.core.DataObjectGroup;
import fr.gouv.vitam.tools.sedalib.core.DataObjectPackageIdElement;
import fr.gouv.vitam.tools.sedalib.core.DataObjectRefList;
import fr.gouv.vitam.tools.sedalib.core.PhysicalDataObject;
import fr.gouv.vitam.tools.sedalib.metadata.content.Content;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.IntegerType;
import fr.gouv.vitam.tools.sedalib.utils.SEDALibException;
import fr.gouv.vitam.tools.sedalib.utils.SEDALibProgressLogger;
import fr.gouv.vitam.tools.sedalib.xml.SEDAXMLEventReader;
import fr.gouv.vitam.tools.sedalib.xml.SEDAXMLStreamWriter;
import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;

public class DataObjectPackage {
    private HashMap<String, ArchiveUnit> auInDataObjectPackageIdMap = new HashMap();
    private HashMap<String, DataObjectGroup> dogInDataObjectPackageIdMap = new HashMap();
    private HashMap<String, BinaryDataObject> bdoInDataObjectPackageIdMap = new HashMap();
    private HashMap<String, PhysicalDataObject> pdoInDataObjectPackageIdMap = new HashMap();
    private String managementMetadataXmlData;
    private ArchiveUnit ghostRootAu = new ArchiveUnit();
    private List<String> exportMetadataList;
    private int idCounter;
    private int refIdCounter;
    private int inOutCounter;
    private final HashMap<String, Integer> touchedInDataObjectPackageIdMap;
    public static final int NORMALIZATION_STATUS_UNKNOWN = 0;
    public static final int NORMALIZATION_STATUS_OK = 1;
    public static final int NORMALIZATION_STATUS_KO = 2;
    private int vitamNormalizationStatus;
    private static final Comparator<String> idComparator = (id1, id2) -> {
        if (id1.toLowerCase().startsWith("id") && id2.toLowerCase().startsWith("id")) {
            try {
                int num1 = Integer.parseInt(id1.substring(2));
                int num2 = Integer.parseInt(id2.substring(2));
                return num1 - num2;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return id1.compareTo((String)id2);
    };

    public DataObjectPackage() {
        Content c = new Content();
        try {
            c.addNewMetadata("Title", "GhostRootAu");
        }
        catch (SEDALibException sEDALibException) {
            // empty catch block
        }
        this.ghostRootAu.setDataObjectPackage(this);
        this.exportMetadataList = null;
        this.resetIdCounter();
        this.resetRefIdCounter();
        this.resetInOutCounter();
        this.touchedInDataObjectPackageIdMap = new HashMap();
        this.vitamNormalizationStatus = 0;
    }

    private boolean isInDataObjectPackageIdUsed(String inDataPackageObjectId) {
        if (this.auInDataObjectPackageIdMap.containsKey(inDataPackageObjectId)) {
            return true;
        }
        if (this.dogInDataObjectPackageIdMap.containsKey(inDataPackageObjectId)) {
            return true;
        }
        if (this.bdoInDataObjectPackageIdMap.containsKey(inDataPackageObjectId)) {
            return true;
        }
        return this.pdoInDataObjectPackageIdMap.containsKey(inDataPackageObjectId);
    }

    public void addDataObjectPackageIdElement(DataObjectPackageIdElement element) throws SEDALibException {
        if (element.inDataPackageObjectId == null) {
            element.inDataPackageObjectId = this.getNextInDataObjectPackageID();
        }
        if (this.isInDataObjectPackageIdUsed(element.inDataPackageObjectId)) {
            throw new SEDALibException("Deux objets ne peuvent avoir la m\u00eame r\u00e9f\u00e9rence [" + element.inDataPackageObjectId + "]");
        }
        if (element instanceof ArchiveUnit) {
            this.auInDataObjectPackageIdMap.put(element.inDataPackageObjectId, (ArchiveUnit)element);
        } else if (element instanceof DataObjectGroup) {
            this.dogInDataObjectPackageIdMap.put(element.inDataPackageObjectId, (DataObjectGroup)element);
        } else if (element instanceof BinaryDataObject) {
            this.bdoInDataObjectPackageIdMap.put(element.inDataPackageObjectId, (BinaryDataObject)element);
        } else if (element instanceof PhysicalDataObject) {
            this.pdoInDataObjectPackageIdMap.put(element.inDataPackageObjectId, (PhysicalDataObject)element);
        }
        element.setDataObjectPackage(this);
    }

    public void addArchiveUnit(ArchiveUnit au) throws SEDALibException {
        if (au.inDataPackageObjectId == null) {
            au.inDataPackageObjectId = this.getNextInDataObjectPackageID();
        }
        if (this.isInDataObjectPackageIdUsed(au.inDataPackageObjectId)) {
            throw new SEDALibException("Deux objets ne peuvent avoir la m\u00eame r\u00e9f\u00e9rence [" + au.inDataPackageObjectId + "]");
        }
        this.auInDataObjectPackageIdMap.put(au.inDataPackageObjectId, au);
        au.setDataObjectPackage(this);
    }

    public void addDataObjectGroup(DataObjectGroup dog) throws SEDALibException {
        if (dog.inDataPackageObjectId == null) {
            dog.inDataPackageObjectId = this.getNextInDataObjectPackageID();
        }
        if (this.isInDataObjectPackageIdUsed(dog.inDataPackageObjectId)) {
            throw new SEDALibException("Deux objets ne peuvent avoir la m\u00eame r\u00e9f\u00e9rence [" + dog.inDataPackageObjectId + "]");
        }
        this.dogInDataObjectPackageIdMap.put(dog.inDataPackageObjectId, dog);
        dog.setDataObjectPackage(this);
    }

    public void resetTouchedInDataObjectPackageIdMap() {
        this.touchedInDataObjectPackageIdMap.clear();
    }

    public boolean isTouchedInDataObjectPackageId(String inDataObjectPackageId) {
        return this.touchedInDataObjectPackageIdMap.containsKey(inDataObjectPackageId);
    }

    public void addTouchedInDataObjectPackageId(String inDataObjectPackageId) {
        this.touchedInDataObjectPackageIdMap.put(inDataObjectPackageId, 1);
    }

    public void incTouchedInDataObjectPackageId(String inDataObjectPackageId) {
        Integer value = this.touchedInDataObjectPackageIdMap.get(inDataObjectPackageId);
        if (value == null) {
            this.touchedInDataObjectPackageIdMap.put(inDataObjectPackageId, 1);
        } else {
            this.touchedInDataObjectPackageIdMap.put(inDataObjectPackageId, value + 1);
        }
    }

    public Integer getTouchedInDataObjectPackageId(String inDataObjectPackageId) {
        return this.touchedInDataObjectPackageIdMap.get(inDataObjectPackageId);
    }

    public int getArchiveUnitCount() {
        return this.auInDataObjectPackageIdMap.size();
    }

    public int getDataObjectGroupCount() {
        return this.dogInDataObjectPackageIdMap.size();
    }

    public int getBinaryDataObjectCount() {
        return this.bdoInDataObjectPackageIdMap.size();
    }

    public long getDataObjectsTotalSize() {
        long result = 0L;
        for (Map.Entry<String, BinaryDataObject> pair : this.bdoInDataObjectPackageIdMap.entrySet()) {
            IntegerType size = pair.getValue().getMetadataSize();
            if (size == null) continue;
            result += size.getValue().longValue();
        }
        return result;
    }

    public int getPhysicalDataObjectCount() {
        return this.pdoInDataObjectPackageIdMap.size();
    }

    public ArchiveUnit getArchiveUnitById(String inDataObjectPackageId) {
        return this.auInDataObjectPackageIdMap.get(inDataObjectPackageId);
    }

    public DataObjectGroup getDataObjectGroupById(String inDataObjectPackageId) {
        return this.dogInDataObjectPackageIdMap.get(inDataObjectPackageId);
    }

    public DataObject getDataObjectById(String inDataObjectPackageId) {
        DataObject dataObject = this.dogInDataObjectPackageIdMap.get(inDataObjectPackageId);
        if (dataObject != null) {
            return dataObject;
        }
        dataObject = this.bdoInDataObjectPackageIdMap.get(inDataObjectPackageId);
        if (dataObject != null) {
            return dataObject;
        }
        dataObject = this.pdoInDataObjectPackageIdMap.get(inDataObjectPackageId);
        return dataObject;
    }

    public String getNextInDataObjectPackageID() {
        String id = "ID" + this.idCounter++;
        while (this.auInDataObjectPackageIdMap.containsKey(id) || this.dogInDataObjectPackageIdMap.containsKey(id) || this.bdoInDataObjectPackageIdMap.containsKey(id) || this.pdoInDataObjectPackageIdMap.containsKey(id)) {
            id = "ID" + this.idCounter++;
        }
        return id;
    }

    public String getNextRefID() {
        return "RefID" + this.refIdCounter++;
    }

    public void resetRefIdCounter() {
        this.refIdCounter = 1;
    }

    public void resetIdCounter() {
        this.idCounter = 10;
    }

    private static String readableFileSize(long size) {
        if (size <= 0L) {
            return "0";
        }
        String[] units = new String[]{"B", "kB", "MB", "GB", "TB"};
        int digitGroups = (int)(Math.log10(size) / Math.log10(1024.0));
        return new DecimalFormat("#,##0.#").format((double)size / Math.pow(1024.0, digitGroups)) + " " + units[digitGroups];
    }

    public String getDescription() {
        String result = "  - " + this.getArchiveUnitCount() + " ArchiveUnit(s)\n  - " + this.getDataObjectGroupCount() + " DataObjectGroup(s)\n  - " + this.getBinaryDataObjectCount() + " BinaryDataObject(s) (" + DataObjectPackage.readableFileSize(this.getDataObjectsTotalSize()) + ")\n  - " + this.getPhysicalDataObjectCount() + " PhysicalDataObject(s)";
        return result;
    }

    private void setAllReferencesByObjects() {
        for (Map.Entry<String, ArchiveUnit> pair : this.getAuInDataObjectPackageIdMap().entrySet()) {
            pair.getValue().getChildrenAuList().getArchiveUnitList();
            pair.getValue().getDataObjectRefList().getDataObjectList();
        }
        this.getGhostRootAu().getChildrenAuList().getArchiveUnitList();
    }

    public void moveContentFromDataObjectPackage(DataObjectPackage childDataObjectPackage, ArchiveUnit targetAU) {
        childDataObjectPackage.setAllReferencesByObjects();
        for (Map.Entry<String, ArchiveUnit> entry : childDataObjectPackage.getAuInDataObjectPackageIdMap().entrySet()) {
            entry.getValue().setInDataObjectPackageId(null);
            try {
                this.addArchiveUnit(entry.getValue());
            }
            catch (SEDALibException sEDALibException) {}
        }
        for (Map.Entry<String, DataObjectPackageIdElement> entry : childDataObjectPackage.getDogInDataObjectPackageIdMap().entrySet()) {
            ((DataObjectGroup)entry.getValue()).setInDataObjectPackageId(null);
            try {
                this.addDataObjectGroup((DataObjectGroup)entry.getValue());
            }
            catch (SEDALibException sEDALibException) {}
        }
        for (Map.Entry<String, DataObjectPackageIdElement> entry : childDataObjectPackage.getBdoInDataObjectPackageIdMap().entrySet()) {
            ((BinaryDataObject)entry.getValue()).setInDataObjectPackageId(null);
            try {
                this.addDataObjectPackageIdElement(entry.getValue());
            }
            catch (SEDALibException sEDALibException) {}
        }
        for (Map.Entry<String, DataObjectPackageIdElement> entry : childDataObjectPackage.getPdoInDataObjectPackageIdMap().entrySet()) {
            ((PhysicalDataObject)entry.getValue()).setInDataObjectPackageId(null);
            try {
                this.addDataObjectPackageIdElement(entry.getValue());
            }
            catch (SEDALibException sEDALibException) {}
        }
        for (ArchiveUnit archiveUnit : childDataObjectPackage.ghostRootAu.getChildrenAuList().getArchiveUnitList()) {
            targetAU.addChildArchiveUnit(archiveUnit);
        }
        childDataObjectPackage.setAuInDataObjectPackageIdMap(new HashMap<String, ArchiveUnit>());
        childDataObjectPackage.setDogInDataObjectPackageIdMap(new HashMap<String, DataObjectGroup>());
        childDataObjectPackage.setBdoInDataObjectPackageIdMap(new HashMap<String, BinaryDataObject>());
        childDataObjectPackage.setPdoInDataObjectPackageIdMap(new HashMap<String, PhysicalDataObject>());
        childDataObjectPackage.setGhostRootAu(new ArchiveUnit());
        Content c = new Content();
        try {
            c.addNewMetadata("Title", "GhostRootAu");
        }
        catch (SEDALibException sEDALibException) {
            // empty catch block
        }
        childDataObjectPackage.getGhostRootAu().setDataObjectPackage(this);
        childDataObjectPackage.getGhostRootAu().setContent(c);
    }

    private String archiveUnitPathToString(List<ArchiveUnit> path) {
        StringBuilder result = new StringBuilder();
        if (path != null) {
            for (ArchiveUnit au : path) {
                result.append(au.getInDataObjectPackageId()).append("->");
            }
        }
        return result.toString();
    }

    private void verifyAcyclicArchiveUnit(ArchiveUnit au, List<ArchiveUnit> path) throws SEDALibException {
        if (path.contains(au)) {
            throw new SEDALibException("Cycle d\u00e9tect\u00e9 " + this.archiveUnitPathToString(path) + au.getInDataObjectPackageId());
        }
        if (this.isTouchedInDataObjectPackageId(au.getInDataObjectPackageId())) {
            return;
        }
        path.add(au);
        for (ArchiveUnit childAu : au.getChildrenAuList().getArchiveUnitList()) {
            this.verifyAcyclicArchiveUnit(childAu, path);
        }
        path.remove(au);
        this.addTouchedInDataObjectPackageId(au.getInDataObjectPackageId());
    }

    public void verifyAcyclic() throws SEDALibException {
        ArrayList<ArchiveUnit> path = new ArrayList<ArchiveUnit>();
        this.resetTouchedInDataObjectPackageIdMap();
        for (ArchiveUnit childAu : this.ghostRootAu.getChildrenAuList().getArchiveUnitList()) {
            this.verifyAcyclicArchiveUnit(childAu, path);
        }
    }

    private void countDogReferencesArchiveUnit(ArchiveUnit archiveUnit) {
        if (this.isTouchedInDataObjectPackageId(archiveUnit.getInDataObjectPackageId())) {
            return;
        }
        for (DataObject zdo : archiveUnit.getDataObjectRefList().getDataObjectList()) {
            if (!(zdo instanceof DataObjectGroup)) continue;
            this.incTouchedInDataObjectPackageId(zdo.getInDataObjectPackageId());
        }
        for (ArchiveUnit childAu : archiveUnit.getChildrenAuList().getArchiveUnitList()) {
            this.countDogReferencesArchiveUnit(childAu);
        }
        this.addTouchedInDataObjectPackageId(archiveUnit.getInDataObjectPackageId());
    }

    public void verifyDogUnicityCapacity() throws SEDALibException {
        this.resetTouchedInDataObjectPackageIdMap();
        for (ArchiveUnit archiveUnit : this.ghostRootAu.getChildrenAuList().getArchiveUnitList()) {
            this.countDogReferencesArchiveUnit(archiveUnit);
        }
        for (Map.Entry entry : this.getAuInDataObjectPackageIdMap().entrySet()) {
            DataObjectRefList dorl = ((ArchiveUnit)entry.getValue()).getDataObjectRefList();
            boolean referencedDog = false;
            for (DataObject zdo : dorl.getDataObjectList()) {
                if (!(zdo instanceof DataObjectGroup) || this.getTouchedInDataObjectPackageId(zdo.getInDataObjectPackageId()) <= 1) continue;
                referencedDog = true;
            }
            if (!referencedDog || dorl.getCount() <= 1) continue;
            throw new SEDALibException("Regroupement des r\u00e9f\u00e9rences de DataObject impossible sur l'ArchiveUnit [" + ((ArchiveUnit)entry.getValue()).getInDataObjectPackageId() + "]");
        }
    }

    private void putAllInDog(DataObjectGroup dataObjectGroup, DataObjectRefList dorl) throws SEDALibException {
        for (DataObject zdo : dorl.getDataObjectList()) {
            if (zdo instanceof DataObjectGroup) {
                dataObjectGroup.mergeDataObjectGroup((DataObjectGroup)zdo);
                this.dogInDataObjectPackageIdMap.remove(zdo.getInDataObjectPackageId());
                continue;
            }
            if (!(zdo instanceof BinaryDataObject) && !(zdo instanceof PhysicalDataObject)) continue;
            dataObjectGroup.addDataObject(zdo);
        }
    }

    public void normalizeUniqDataObjectGroup() throws SEDALibException {
        this.verifyDogUnicityCapacity();
        for (Map.Entry<String, ArchiveUnit> pair : this.getAuInDataObjectPackageIdMap().entrySet()) {
            DataObjectRefList dorl = pair.getValue().getDataObjectRefList();
            if ((dorl.getCount() != 1 || dorl.getDataObjectList().get(0) instanceof DataObjectGroup) && dorl.getCount() <= 1) continue;
            DataObjectGroup dog = new DataObjectGroup(this, null);
            this.putAllInDog(dog, pair.getValue().getDataObjectRefList());
            dorl = new DataObjectRefList(this);
            dorl.add(dog);
            pair.getValue().setDataObjectRefList(dorl);
        }
    }

    public void removeUnusedDataObjects(SEDALibProgressLogger spl) throws InterruptedException {
        HashSet<DataObject> usedDataObjects = new HashSet<DataObject>(1000);
        for (Map.Entry<String, ArchiveUnit> pair : this.getAuInDataObjectPackageIdMap().entrySet()) {
            DataObjectRefList dorl = pair.getValue().getDataObjectRefList();
            for (DataObject dataObject : dorl.getDataObjectList()) {
                usedDataObjects.add(dataObject);
                if (!(dataObject instanceof DataObjectGroup)) continue;
                usedDataObjects.addAll(((DataObjectGroup)dataObject).getPhysicalDataObjectList());
                usedDataObjects.addAll(((DataObjectGroup)dataObject).getBinaryDataObjectList());
            }
        }
        Iterator<Map.Entry<String, DataObjectGroup>> iteratorDog = this.getDogInDataObjectPackageIdMap().entrySet().iterator();
        while (iteratorDog.hasNext()) {
            Map.Entry<String, DataObjectGroup> entry = iteratorDog.next();
            if (usedDataObjects.contains(entry.getValue())) continue;
            iteratorDog.remove();
            SEDALibProgressLogger.doProgressLog(spl, 10, "sedalib: un DataObjectGroup [" + entry.getKey() + "] d\u00e9clar\u00e9 n'est pas utilis\u00e9, il est d\u00e9r\u00e9f\u00e9renc\u00e9.", null);
        }
        Iterator<Map.Entry<String, BinaryDataObject>> iteratorBdo = this.getBdoInDataObjectPackageIdMap().entrySet().iterator();
        while (iteratorBdo.hasNext()) {
            Map.Entry<String, BinaryDataObject> entry = iteratorBdo.next();
            if (usedDataObjects.contains(entry.getValue())) continue;
            iteratorBdo.remove();
            SEDALibProgressLogger.doProgressLog(spl, 10, "sedalib: un BinaryDataObject [" + entry.getKey() + "] d\u00e9clar\u00e9 n'est pas utilis\u00e9, il est d\u00e9r\u00e9f\u00e9renc\u00e9.", null);
        }
        Iterator<Map.Entry<String, PhysicalDataObject>> iteratorPdo = this.getPdoInDataObjectPackageIdMap().entrySet().iterator();
        while (iteratorPdo.hasNext()) {
            Map.Entry<String, PhysicalDataObject> entry = iteratorPdo.next();
            if (usedDataObjects.contains(entry.getValue())) continue;
            iteratorPdo.remove();
            SEDALibProgressLogger.doProgressLog(spl, 10, "sedalib: un PhysicalDataObject [" + entry.getKey() + "] d\u00e9clar\u00e9 n'est pas utilis\u00e9, il est d\u00e9r\u00e9f\u00e9renc\u00e9.", null);
        }
    }

    private void regenerateArchiveUnitId(ArchiveUnit archiveUnit, List<DataObjectGroup> orderedDataObjectGroupList) {
        if (archiveUnit.inDataPackageObjectId == null) {
            DataObjectGroup dog = archiveUnit.getDataObjectRefList().getNormalizedDataObjectGroup();
            if (dog != null) {
                orderedDataObjectGroupList.add(dog);
            }
            try {
                this.addArchiveUnit(archiveUnit);
            }
            catch (SEDALibException sEDALibException) {
                // empty catch block
            }
            for (ArchiveUnit childAu : archiveUnit.getChildrenAuList().getArchiveUnitList()) {
                this.regenerateArchiveUnitId(childAu, orderedDataObjectGroupList);
            }
        }
    }

    private void regenerateDataObjectGroup(DataObjectGroup dataObjectGroup) {
        if (dataObjectGroup.inDataPackageObjectId == null) {
            try {
                this.addDataObjectGroup(dataObjectGroup);
            }
            catch (SEDALibException sEDALibException) {
                // empty catch block
            }
            for (BinaryDataObject bdo : dataObjectGroup.getBinaryDataObjectList()) {
                bdo.inDataPackageObjectId = null;
                try {
                    this.addDataObjectPackageIdElement(bdo);
                }
                catch (SEDALibException sEDALibException) {}
            }
            for (PhysicalDataObject pdo : dataObjectGroup.getPhysicalDataObjectList()) {
                pdo.inDataPackageObjectId = null;
                try {
                    this.addDataObjectPackageIdElement(pdo);
                }
                catch (SEDALibException sEDALibException) {}
            }
        }
    }

    private void removeArchiveUnitAndDataObjectGroupId() {
        for (Map.Entry<String, ArchiveUnit> entry : this.auInDataObjectPackageIdMap.entrySet()) {
            entry.getValue().setInDataObjectPackageId(null);
        }
        for (Map.Entry<String, DataObjectPackageIdElement> entry : this.dogInDataObjectPackageIdMap.entrySet()) {
            ((DataObjectGroup)entry.getValue()).setInDataObjectPackageId(null);
        }
    }

    public void regenerateContinuousIds() {
        this.setAllReferencesByObjects();
        this.removeArchiveUnitAndDataObjectGroupId();
        this.resetIdCounter();
        this.auInDataObjectPackageIdMap = new HashMap();
        this.dogInDataObjectPackageIdMap = new HashMap();
        this.bdoInDataObjectPackageIdMap = new HashMap();
        this.pdoInDataObjectPackageIdMap = new HashMap();
        this.resetInOutCounter();
        ArrayList<DataObjectGroup> orderedDataObjectGroupList = new ArrayList<DataObjectGroup>(this.dogInDataObjectPackageIdMap.size());
        for (ArchiveUnit root : this.ghostRootAu.getChildrenAuList().getArchiveUnitList()) {
            this.regenerateArchiveUnitId(root, orderedDataObjectGroupList);
        }
        this.resetInOutCounter();
        for (DataObjectGroup zdo : orderedDataObjectGroupList) {
            this.regenerateDataObjectGroup(zdo);
        }
    }

    private void actualiseDataObjectId(DataObject dataObject) {
        if (!this.isTouchedInDataObjectPackageId(dataObject.getInDataObjectPackageId())) {
            if (dataObject instanceof DataObjectGroup) {
                DataObjectGroup dataObjectGroup = (DataObjectGroup)dataObject;
                this.dogInDataObjectPackageIdMap.put(dataObjectGroup.inDataPackageObjectId, dataObjectGroup);
                for (BinaryDataObject bdo : dataObjectGroup.getBinaryDataObjectList()) {
                    this.bdoInDataObjectPackageIdMap.put(bdo.getInDataObjectPackageId(), bdo);
                }
                for (PhysicalDataObject pdo : dataObjectGroup.getPhysicalDataObjectList()) {
                    this.pdoInDataObjectPackageIdMap.put(pdo.getInDataObjectPackageId(), pdo);
                }
            } else if (dataObject instanceof BinaryDataObject) {
                this.bdoInDataObjectPackageIdMap.put(dataObject.getInDataObjectPackageId(), (BinaryDataObject)dataObject);
            } else if (dataObject instanceof PhysicalDataObject) {
                this.pdoInDataObjectPackageIdMap.put(dataObject.getInDataObjectPackageId(), (PhysicalDataObject)dataObject);
            }
        }
    }

    private void actualiseArchiveUnitId(ArchiveUnit archiveUnit, List<DataObject> orderedDataObjectList) {
        if (!this.isTouchedInDataObjectPackageId(archiveUnit.inDataPackageObjectId)) {
            this.addTouchedInDataObjectPackageId(archiveUnit.inDataPackageObjectId);
            orderedDataObjectList.addAll(archiveUnit.getDataObjectRefList().getDataObjectList());
            this.auInDataObjectPackageIdMap.put(archiveUnit.inDataPackageObjectId, archiveUnit);
            for (ArchiveUnit childAu : archiveUnit.getChildrenAuList().getArchiveUnitList()) {
                this.actualiseArchiveUnitId(childAu, orderedDataObjectList);
            }
        }
    }

    public void actualiseIdMaps() {
        ArrayList<DataObject> orderedDataObjectList = new ArrayList<DataObject>(this.dogInDataObjectPackageIdMap.size() + this.bdoInDataObjectPackageIdMap.size() + this.pdoInDataObjectPackageIdMap.size());
        this.setAllReferencesByObjects();
        this.resetTouchedInDataObjectPackageIdMap();
        this.auInDataObjectPackageIdMap = new HashMap();
        this.dogInDataObjectPackageIdMap = new HashMap();
        this.bdoInDataObjectPackageIdMap = new HashMap();
        this.pdoInDataObjectPackageIdMap = new HashMap();
        for (ArchiveUnit root : this.ghostRootAu.getChildrenAuList().getArchiveUnitList()) {
            this.actualiseArchiveUnitId(root, orderedDataObjectList);
        }
        for (DataObject dataObject : orderedDataObjectList) {
            this.actualiseDataObjectId(dataObject);
        }
    }

    public void vitamNormalize(SEDALibProgressLogger spl) throws SEDALibException, InterruptedException {
        this.vitamNormalizationStatus = 2;
        this.verifyAcyclic();
        this.normalizeUniqDataObjectGroup();
        this.removeUnusedDataObjects(spl);
        this.vitamNormalizationStatus = 1;
    }

    public boolean removeEmptyArchiveUnit(ArchiveUnit archiveUnit) {
        if (archiveUnit.getChildrenAuList().getCount() != 0) {
            return false;
        }
        if (archiveUnit.getDataObjectRefList().getCount() != 0) {
            return false;
        }
        for (Map.Entry<String, ArchiveUnit> e : this.auInDataObjectPackageIdMap.entrySet()) {
            e.getValue().getChildrenAuList().getArchiveUnitList().remove(archiveUnit);
        }
        return this.auInDataObjectPackageIdMap.remove(archiveUnit.inDataPackageObjectId) != null;
    }

    public void exportDataObjectPackageObjects(SEDAXMLStreamWriter xmlWriter, SEDALibProgressLogger sedaLibProgressLogger) throws InterruptedException, SEDALibException {
        try {
            xmlWriter.writeStartElement("DataObjectPackage");
            this.resetTouchedInDataObjectPackageIdMap();
            Set<String> dogSet = this.dogInDataObjectPackageIdMap.keySet();
            Object[] tempArray = dogSet.toArray(new String[0]);
            Arrays.sort(tempArray);
            for (Object s : tempArray) {
                DataObjectGroup dog = this.dogInDataObjectPackageIdMap.get(s);
                dog.toSedaXml(xmlWriter, sedaLibProgressLogger);
                for (BinaryDataObject b : dog.getBinaryDataObjectList()) {
                    this.addTouchedInDataObjectPackageId(b.inDataPackageObjectId);
                }
                for (PhysicalDataObject p : dog.getPhysicalDataObjectList()) {
                    this.addTouchedInDataObjectPackageId(p.inDataPackageObjectId);
                }
            }
            Set<String> bdoSet = this.bdoInDataObjectPackageIdMap.keySet();
            tempArray = bdoSet.toArray(new String[0]);
            Arrays.sort(tempArray);
            for (Object s : tempArray) {
                BinaryDataObject bdo = this.bdoInDataObjectPackageIdMap.get(s);
                if (this.isTouchedInDataObjectPackageId(bdo.inDataPackageObjectId)) continue;
                bdo.toSedaXml(xmlWriter, sedaLibProgressLogger);
            }
            Set<String> pdoSet = this.pdoInDataObjectPackageIdMap.keySet();
            tempArray = pdoSet.toArray(new String[0]);
            Arrays.sort(tempArray);
            for (Object s : tempArray) {
                PhysicalDataObject pdo = this.pdoInDataObjectPackageIdMap.get(s);
                if (this.isTouchedInDataObjectPackageId(pdo.inDataPackageObjectId)) continue;
                pdo.toSedaXml(xmlWriter, sedaLibProgressLogger);
            }
        }
        catch (XMLStreamException e) {
            throw new SEDALibException("Erreur d'\u00e9criture XML des m\u00e9tadonn\u00e9es des DataObjects", e);
        }
        SEDALibProgressLogger.doProgressLog(sedaLibProgressLogger, 30, "sedalib: " + this.getNextInOutCounter() + " m\u00e9tadonn\u00e9es DataObject export\u00e9es dans le DataObjectPackage", null);
    }

    public void exportDataObjectPackageMetadata(SEDAXMLStreamWriter xmlWriter, boolean imbricateFlag, SEDALibProgressLogger sedaLibProgressLogger) throws SEDALibException, InterruptedException {
        try {
            this.resetTouchedInDataObjectPackageIdMap();
            xmlWriter.writeStartElement("DescriptiveMetadata");
            if (!imbricateFlag) {
                Set<String> auSet = this.auInDataObjectPackageIdMap.keySet();
                String[] tempArray = auSet.toArray(new String[0]);
                Arrays.sort(tempArray, idComparator);
                for (String s : tempArray) {
                    this.auInDataObjectPackageIdMap.get(s).toSedaXml(xmlWriter, false, sedaLibProgressLogger);
                }
            } else {
                List<String> roots = this.ghostRootAu.getChildrenAuList().getInDataObjectPackageIdList();
                if (roots != null) {
                    String[] tempArray = roots.toArray(new String[0]);
                    Arrays.sort(tempArray, idComparator);
                    for (String s : tempArray) {
                        this.auInDataObjectPackageIdMap.get(s).toSedaXml(xmlWriter, true, sedaLibProgressLogger);
                    }
                }
            }
            xmlWriter.writeEndElement();
            if (this.managementMetadataXmlData != null) {
                xmlWriter.writeRawXMLBlockIfNotEmpty(this.managementMetadataXmlData);
            } else {
                xmlWriter.writeRawXMLBlockIfNotEmpty("<ManagementMetadata/>");
            }
            xmlWriter.writeEndElement();
            xmlWriter.flush();
        }
        catch (SEDALibException | XMLStreamException e) {
            throw new SEDALibException("Erreur d'\u00e9criture XML des m\u00e9tadonn\u00e9es dans le DataObjectPackage", e);
        }
        SEDALibProgressLogger.doProgressLog(sedaLibProgressLogger, 30, "sedalib: " + this.getNextInOutCounter() + " m\u00e9tadonn\u00e9es ArchiveUnit export\u00e9es dans le DataObjectPackage", null);
    }

    public void toSedaXml(SEDAXMLStreamWriter xmlWriter, boolean imbricateFlag, SEDALibProgressLogger sedaLibProgressLogger) throws SEDALibException, InterruptedException {
        this.resetRefIdCounter();
        this.resetInOutCounter();
        this.exportDataObjectPackageObjects(xmlWriter, sedaLibProgressLogger);
        this.resetInOutCounter();
        this.exportDataObjectPackageMetadata(xmlWriter, imbricateFlag, sedaLibProgressLogger);
    }

    public static void importDataObjectPackageObjects(SEDAXMLEventReader xmlReader, DataObjectPackage dataObjectPackage, String rootDir, SEDALibProgressLogger sedaLibProgressLogger) throws SEDALibException, InterruptedException {
        boolean inDataObjectObjects = true;
        try {
            if (!xmlReader.nextBlockIfNamed("DataObjectPackage")) {
                throw new SEDALibException("Pas d'\u00e9l\u00e9ment DataObjectPackage");
            }
            block12: while (inDataObjectObjects) {
                String tmp;
                switch (tmp = xmlReader.peekName()) {
                    case "DataObjectGroup": {
                        String dogId = DataObjectGroup.idFromSedaXml(xmlReader, dataObjectPackage, rootDir, sedaLibProgressLogger);
                        SEDALibProgressLogger.doProgressLog(sedaLibProgressLogger, 40, "sedalib: DataObjectGroup [" + dogId + "] import\u00e9", null);
                        continue block12;
                    }
                    case "BinaryDataObject": {
                        BinaryDataObject bdo = BinaryDataObject.fromSedaXml(xmlReader, dataObjectPackage, sedaLibProgressLogger);
                        bdo.setOnDiskPathFromString(rootDir + File.separator + bdo.getMetadataUri().getValue());
                        SEDALibProgressLogger.doProgressLog(sedaLibProgressLogger, 40, "sedalib: BinaryDataObject [" + bdo.inDataPackageObjectId + "] import\u00e9", null);
                        continue block12;
                    }
                    case "PhysicalDataObject": {
                        PhysicalDataObject pdo = PhysicalDataObject.fromSedaXml(xmlReader, dataObjectPackage, sedaLibProgressLogger);
                        SEDALibProgressLogger.doProgressLog(sedaLibProgressLogger, 40, "sedalib: PhysicalDataObject [" + pdo.inDataPackageObjectId + "] import\u00e9", null);
                        continue block12;
                    }
                }
                inDataObjectObjects = false;
            }
        }
        catch (SEDALibException | XMLStreamException e) {
            throw new SEDALibException("Erreur de lecture des m\u00e9tadonn\u00e9es des DataObjects", e);
        }
        SEDALibProgressLogger.doProgressLog(sedaLibProgressLogger, 20, "sedalib: " + dataObjectPackage.getNextInOutCounter() + " m\u00e9tadonn\u00e9es DataObject import\u00e9es depuis le DataObjectPackage", null);
    }

    public static void importDataObjectPackageMetadata(SEDAXMLEventReader xmlReader, DataObjectPackage dataObjectPackage, SEDALibProgressLogger sedaLibProgressLogger) throws SEDALibException, InterruptedException {
        boolean inArchiveUnits = true;
        try {
            String tmp;
            if (!xmlReader.nextBlockIfNamed("DescriptiveMetadata")) {
                throw new SEDALibException("Pas d'\u00e9l\u00e9ment DescriptiveMetadata");
            }
            while (inArchiveUnits && (tmp = xmlReader.peekName()) != null) {
                if ("ArchiveUnit".equals(tmp)) {
                    String auId = ArchiveUnit.idFromSedaXml(xmlReader, dataObjectPackage, sedaLibProgressLogger);
                    SEDALibProgressLogger.doProgressLog(sedaLibProgressLogger, 40, "sedalib: ArchiveUnit [" + auId + "] import\u00e9", null);
                    continue;
                }
                inArchiveUnits = false;
            }
            xmlReader.endBlockNamed("DescriptiveMetadata");
            dataObjectPackage.managementMetadataXmlData = xmlReader.nextMandatoryBlockAsString("ManagementMetadata");
            xmlReader.endBlockNamed("DataObjectPackage");
        }
        catch (SEDALibException | XMLStreamException e) {
            throw new SEDALibException("Erreur de lecture des m\u00e9tadonn\u00e9es des ArchiveUnits", e);
        }
        SEDALibProgressLogger.doProgressLog(sedaLibProgressLogger, 20, "sedalib: " + dataObjectPackage.getNextInOutCounter() + " m\u00e9tadonn\u00e9es ArchiveUnit import\u00e9es depuis le DataObjectPackage", null);
    }

    public static DataObjectPackage fromSedaXml(SEDAXMLEventReader xmlReader, String rootDir, SEDALibProgressLogger sedaLibProgressLogger) throws SEDALibException, InterruptedException {
        DataObjectPackage dataObjectPackage = new DataObjectPackage();
        dataObjectPackage.resetInOutCounter();
        DataObjectPackage.importDataObjectPackageObjects(xmlReader, dataObjectPackage, rootDir, sedaLibProgressLogger);
        dataObjectPackage.resetInOutCounter();
        DataObjectPackage.importDataObjectPackageMetadata(xmlReader, dataObjectPackage, sedaLibProgressLogger);
        dataObjectPackage.resetTouchedInDataObjectPackageIdMap();
        for (Map.Entry<String, ArchiveUnit> pair : dataObjectPackage.auInDataObjectPackageIdMap.entrySet()) {
            ArchiveUnit tmp = pair.getValue();
            if (tmp.getChildrenAuList() == null || tmp.getChildrenAuList().getInDataObjectPackageIdList() == null) continue;
            for (String inDataObjectPackageId : pair.getValue().getChildrenAuList().getInDataObjectPackageIdList()) {
                if (dataObjectPackage.getArchiveUnitById(inDataObjectPackageId) == null) {
                    throw new SEDALibException("Erreur de r\u00e9f\u00e9rence d'ArchiveUnit, [" + inDataObjectPackageId + "] n'existe pas");
                }
                dataObjectPackage.addTouchedInDataObjectPackageId(inDataObjectPackageId);
            }
        }
        for (Map.Entry<String, ArchiveUnit> pair : dataObjectPackage.auInDataObjectPackageIdMap.entrySet()) {
            if (dataObjectPackage.isTouchedInDataObjectPackageId(pair.getValue().inDataPackageObjectId)) continue;
            dataObjectPackage.addRootAu(dataObjectPackage.getArchiveUnitById(pair.getValue().inDataPackageObjectId));
        }
        SEDALibProgressLogger.doProgressLog(sedaLibProgressLogger, 20, "sedalib: manifest import\u00e9", null);
        return dataObjectPackage;
    }

    public HashMap<String, BinaryDataObject> getBdoInDataObjectPackageIdMap() {
        return this.bdoInDataObjectPackageIdMap;
    }

    public void setBdoInDataObjectPackageIdMap(HashMap<String, BinaryDataObject> bdoInDataObjectPackageIdMap) {
        this.bdoInDataObjectPackageIdMap = bdoInDataObjectPackageIdMap;
    }

    public HashMap<String, PhysicalDataObject> getPdoInDataObjectPackageIdMap() {
        return this.pdoInDataObjectPackageIdMap;
    }

    public void setPdoInDataObjectPackageIdMap(HashMap<String, PhysicalDataObject> pdoInDataObjectPackageIdMap) {
        this.pdoInDataObjectPackageIdMap = pdoInDataObjectPackageIdMap;
    }

    public HashMap<String, DataObjectGroup> getDogInDataObjectPackageIdMap() {
        return this.dogInDataObjectPackageIdMap;
    }

    public void setDogInDataObjectPackageIdMap(HashMap<String, DataObjectGroup> dogInDataObjectPackageIdMap) {
        this.dogInDataObjectPackageIdMap = dogInDataObjectPackageIdMap;
    }

    public HashMap<String, ArchiveUnit> getAuInDataObjectPackageIdMap() {
        return this.auInDataObjectPackageIdMap;
    }

    public void setAuInDataObjectPackageIdMap(HashMap<String, ArchiveUnit> auInDataObjectPackageIdMap) {
        this.auInDataObjectPackageIdMap = auInDataObjectPackageIdMap;
    }

    public ArchiveUnit getGhostRootAu() {
        return this.ghostRootAu;
    }

    public void addRootAu(ArchiveUnit au) {
        this.ghostRootAu.getChildrenAuList().add(au);
    }

    public void removeRootAu(ArchiveUnit au) {
        this.ghostRootAu.getChildrenAuList().getArchiveUnitList().remove(au);
    }

    public void setGhostRootAu(ArchiveUnit ghostRootAu) {
        this.ghostRootAu = ghostRootAu;
    }

    public void replaceArchiveUnitBy(ArchiveUnit originArchiveUnit, ArchiveUnit newArchiveUnit) {
        if (this.ghostRootAu.getChildrenAuList().getArchiveUnitList().contains(originArchiveUnit)) {
            this.ghostRootAu.replaceChildArchiveUnit(originArchiveUnit, newArchiveUnit);
        }
        for (ArchiveUnit au : this.auInDataObjectPackageIdMap.values()) {
            if (!au.getChildrenAuList().getArchiveUnitList().contains(originArchiveUnit)) continue;
            au.replaceChildArchiveUnit(originArchiveUnit, newArchiveUnit);
        }
        this.actualiseIdMaps();
    }

    public int getNextInOutCounter() {
        return this.inOutCounter++;
    }

    public void resetInOutCounter() {
        this.inOutCounter = 0;
    }

    public int getVitamNormalizationStatus() {
        return this.vitamNormalizationStatus;
    }

    public void setVitamNormalizationStatus(int vitamNormalizationStatus) {
        this.vitamNormalizationStatus = vitamNormalizationStatus;
    }

    public int getInOutCounter() {
        return this.inOutCounter;
    }

    public String getManagementMetadataXmlData() {
        return this.managementMetadataXmlData;
    }

    public void setManagementMetadataXmlData(String managementMetadataXmlData) {
        this.managementMetadataXmlData = managementMetadataXmlData;
    }

    public List<String> getExportMetadataList() {
        return this.exportMetadataList;
    }

    public void setExportMetadataList(List<String> exportMetadataList) {
        this.exportMetadataList = exportMetadataList;
    }
}

