/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.sedalib.core;

import com.fasterxml.jackson.annotation.JsonIgnore;
import fr.gouv.vitam.tools.sedalib.core.BinaryDataObject;
import fr.gouv.vitam.tools.sedalib.core.DataObject;
import fr.gouv.vitam.tools.sedalib.core.DataObjectPackage;
import fr.gouv.vitam.tools.sedalib.core.DataObjectPackageIdElement;
import fr.gouv.vitam.tools.sedalib.core.PhysicalDataObject;
import fr.gouv.vitam.tools.sedalib.core.seda.SedaContext;
import fr.gouv.vitam.tools.sedalib.metadata.SEDAMetadata;
import fr.gouv.vitam.tools.sedalib.metadata.management.LogBook;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.StringType;
import fr.gouv.vitam.tools.sedalib.utils.SEDALibException;
import fr.gouv.vitam.tools.sedalib.utils.SEDALibProgressLogger;
import fr.gouv.vitam.tools.sedalib.xml.SEDAXMLEventReader;
import fr.gouv.vitam.tools.sedalib.xml.SEDAXMLStreamWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;

public class DataObjectGroup
extends DataObjectPackageIdElement
implements DataObject {
    private List<BinaryDataObject> binaryDataObjectList = new ArrayList<BinaryDataObject>();
    private List<PhysicalDataObject> physicalDataObjectList = new ArrayList<PhysicalDataObject>();
    public LogBook logBook = null;

    public DataObjectGroup() {
        this(null, null);
    }

    public DataObjectGroup(DataObjectPackage dataObjectPackage, Path path) {
        super(dataObjectPackage);
        this.onDiskPath = path == null ? null : path.toAbsolutePath().normalize();
        if (dataObjectPackage != null) {
            try {
                dataObjectPackage.addDataObjectGroup(this);
            }
            catch (SEDALibException sEDALibException) {
                // empty catch block
            }
        }
    }

    public void addDataObject(DataObject dataObject) {
        if (dataObject instanceof BinaryDataObject) {
            this.binaryDataObjectList.add((BinaryDataObject)dataObject);
            ((BinaryDataObject)dataObject).setDataObjectGroup(this);
        } else if (dataObject instanceof PhysicalDataObject) {
            this.physicalDataObjectList.add((PhysicalDataObject)dataObject);
            ((PhysicalDataObject)dataObject).setDataObjectGroup(this);
        }
    }

    public boolean removeDataObject(DataObject zdo) {
        boolean result = false;
        if (zdo instanceof BinaryDataObject) {
            result = this.binaryDataObjectList.remove(zdo);
            if (result) {
                this.getDataObjectPackage().getBdoInDataObjectPackageIdMap().remove(zdo.getInDataObjectPackageId());
            }
        } else if (zdo instanceof PhysicalDataObject && (result = this.physicalDataObjectList.remove(zdo))) {
            this.getDataObjectPackage().getBdoInDataObjectPackageIdMap().remove(zdo.getInDataObjectPackageId());
        }
        return result;
    }

    public DataObject findDataObjectByDataObjectVersion(String dataObjectVersion) {
        for (BinaryDataObject bdo : this.binaryDataObjectList) {
            StringType bdoDataObjectVersion = bdo.getMetadataDataObjectVersion();
            if (bdoDataObjectVersion == null || !bdoDataObjectVersion.getValue().equals(dataObjectVersion)) continue;
            return bdo;
        }
        for (PhysicalDataObject pdo : this.physicalDataObjectList) {
            StringType pdoDataObjectVersion = pdo.getMetadataDataObjectVersion();
            if (pdoDataObjectVersion == null || !pdoDataObjectVersion.getValue().equals(dataObjectVersion)) continue;
            return pdo;
        }
        return null;
    }

    public void mergeDataObjectGroup(DataObjectGroup dataObjectGroup) throws SEDALibException {
        this.getDataObjectPackage().getDogInDataObjectPackageIdMap().remove(dataObjectGroup.getInDataObjectPackageId());
        for (BinaryDataObject bdo : dataObjectGroup.getBinaryDataObjectList()) {
            this.addDataObject(bdo);
        }
        for (PhysicalDataObject pdo : dataObjectGroup.getPhysicalDataObjectList()) {
            this.addDataObject(pdo);
        }
        if (this.logBook == null) {
            this.logBook = dataObjectGroup.logBook;
        } else if (dataObjectGroup.logBook != null) {
            this.logBook = (LogBook)SEDAMetadata.fromString(this.logBook.toString().replace("</LogBook>", "") + dataObjectGroup.logBook.toString().replace("<LogBook>", ""), LogBook.class);
        }
    }

    @Override
    public void toSedaXml(SEDAXMLStreamWriter xmlWriter, SEDALibProgressLogger sedaLibProgressLogger) throws SEDALibException, InterruptedException {
        try {
            xmlWriter.writeStartElement("DataObjectGroup");
            xmlWriter.writeAttribute("id", this.inDataPackageObjectId);
            for (BinaryDataObject binaryDataObject : this.binaryDataObjectList) {
                binaryDataObject.toSedaXml(xmlWriter, sedaLibProgressLogger);
            }
            for (PhysicalDataObject physicalDataObject : this.physicalDataObjectList) {
                physicalDataObject.toSedaXml(xmlWriter, sedaLibProgressLogger);
            }
            if (this.logBook != null) {
                this.logBook.toSedaXml(xmlWriter);
            }
            xmlWriter.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new SEDALibException("Erreur d'\u00e9criture XML du DataObjectGroup [" + this.inDataPackageObjectId + "]", e);
        }
    }

    @Override
    public String toSedaXmlFragments() {
        if (this.logBook == null) {
            return "";
        }
        return this.logBook.toString();
    }

    public static String idFromSedaXml(SEDAXMLEventReader xmlReader, DataObjectPackage dataObjectPackage, String rootDir, SEDALibProgressLogger sedaLibProgressLogger) throws SEDALibException, InterruptedException {
        DataObjectGroup dog = null;
        try {
            String tmp = xmlReader.peekAttributeBlockIfNamed("DataObjectGroup", "id");
            if (tmp != null) {
                dog = new DataObjectGroup();
                dog.inDataPackageObjectId = tmp;
                dataObjectPackage.addDataObjectGroup(dog);
                xmlReader.nextUsefullEvent();
                boolean loop = true;
                block10: while (loop && (tmp = xmlReader.peekName()) != null) {
                    switch (tmp) {
                        case "BinaryDataObject": {
                            BinaryDataObject bdo = BinaryDataObject.fromSedaXml(xmlReader, dataObjectPackage, sedaLibProgressLogger);
                            StringType bdoDataObjectGroupId = (StringType)bdo.getFirstNamedMetadata("DataObjectGroupId");
                            StringType bdoDataObjectGroupReferenceId = (StringType)bdo.getFirstNamedMetadata("DataObjectGroupReferenceId");
                            if (bdoDataObjectGroupId != null || bdoDataObjectGroupReferenceId != null) {
                                throw new SEDALibException("Le BinaryDataObject [" + bdo.inDataPackageObjectId + "] utilise un raccordement DataObjectGroup mode SEDA2.0 dans un DataObjectGroup mode " + SedaContext.getVersion());
                            }
                            StringType bdoUri = (StringType)bdo.getFirstNamedMetadata("Uri");
                            bdo.setOnDiskPathFromString(rootDir + File.separator + bdoUri.getValue());
                            dog.addDataObject(bdo);
                            continue block10;
                        }
                        case "PhysicalDataObject": {
                            PhysicalDataObject pdo = PhysicalDataObject.fromSedaXml(xmlReader, dataObjectPackage, sedaLibProgressLogger);
                            StringType dataObjectGroupId = (StringType)pdo.getFirstNamedMetadata("DataObjectGroupId");
                            StringType dataObjectGroupReferenceId = (StringType)pdo.getFirstNamedMetadata("DataObjectGroupReferenceId");
                            if (dataObjectGroupId != null || dataObjectGroupReferenceId != null) {
                                throw new SEDALibException("Le PhysicalDataObject [" + pdo.inDataPackageObjectId + "] utilise un raccordement DataObjectGroup mode SEDA2.0 dans un DataObjectGroup mode " + SedaContext.getVersion());
                            }
                            dog.addDataObject(pdo);
                            continue block10;
                        }
                    }
                    loop = false;
                }
                String nextElementName = xmlReader.peekName();
                if (nextElementName != null && nextElementName.equals("LogBook")) {
                    dog.logBook = (LogBook)SEDAMetadata.fromSedaXml(xmlReader, LogBook.class);
                }
                xmlReader.endBlockNamed("DataObjectGroup");
            }
        }
        catch (SEDALibException | XMLStreamException e) {
            throw new SEDALibException("Erreur de lecture du DataObjectGroup" + (String)(dog != null ? " [" + dog.inDataPackageObjectId + "]" : ""), e);
        }
        if (dog == null) {
            return null;
        }
        return dog.inDataPackageObjectId;
    }

    @Override
    public void fromSedaXmlFragments(String fragments) throws SEDALibException {
        DataObjectGroup dog = new DataObjectGroup();
        try (ByteArrayInputStream bais = new ByteArrayInputStream(fragments.getBytes(StandardCharsets.UTF_8));
             SEDAXMLEventReader xmlReader = new SEDAXMLEventReader(bais, true);){
            xmlReader.nextUsefullEvent();
            String nextElementName = xmlReader.peekName();
            if (nextElementName != null && nextElementName.equals("LogBook")) {
                dog.logBook = (LogBook)SEDAMetadata.fromSedaXml(xmlReader, LogBook.class);
            }
        }
        catch (SEDALibException | IOException | XMLStreamException e) {
            throw new SEDALibException("Erreur de lecture du DataObjectGroup", e);
        }
        this.logBook = dog.logBook;
    }

    public List<BinaryDataObject> getBinaryDataObjectList() {
        return this.binaryDataObjectList;
    }

    public void setBinaryDataObjectList(List<BinaryDataObject> binaryDataObjectList) {
        this.binaryDataObjectList = binaryDataObjectList;
    }

    public List<PhysicalDataObject> getPhysicalDataObjectList() {
        return this.physicalDataObjectList;
    }

    public void setPhysicalDataObjectList(List<PhysicalDataObject> physicalDataObjectList) {
        this.physicalDataObjectList = physicalDataObjectList;
    }

    @Override
    @JsonIgnore
    public DataObjectGroup getDataObjectGroup() {
        return this;
    }

    public LogBook getLogBook() {
        return this.logBook;
    }

    public void setLogBook(LogBook logBook) {
        this.logBook = logBook;
    }
}

