/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.sedalib.core;

import com.fasterxml.jackson.annotation.JsonIgnore;
import fr.gouv.vitam.tools.sedalib.core.AbstractUnitaryDataObject;
import fr.gouv.vitam.tools.sedalib.core.DataObject;
import fr.gouv.vitam.tools.sedalib.core.DataObjectGroup;
import fr.gouv.vitam.tools.sedalib.core.DataObjectPackage;
import fr.gouv.vitam.tools.sedalib.core.seda.SedaVersion;
import fr.gouv.vitam.tools.sedalib.droid.DroidIdentifier;
import fr.gouv.vitam.tools.sedalib.metadata.content.PersistentIdentifier;
import fr.gouv.vitam.tools.sedalib.metadata.data.FileInfo;
import fr.gouv.vitam.tools.sedalib.metadata.data.FormatIdentification;
import fr.gouv.vitam.tools.sedalib.metadata.data.Metadata;
import fr.gouv.vitam.tools.sedalib.metadata.data.Relationship;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.AnyXMLListType;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.ComplexListInterface;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.ComplexListMetadataKind;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.ComplexListMetadataMap;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.DigestType;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.IntegerType;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.StringType;
import fr.gouv.vitam.tools.sedalib.utils.SEDALibException;
import fr.gouv.vitam.tools.sedalib.utils.SEDALibProgressLogger;
import fr.gouv.vitam.tools.sedalib.xml.SEDAXMLEventReader;
import fr.gouv.vitam.tools.sedalib.xml.SEDAXMLStreamWriter;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileTime;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationResult;

public class BinaryDataObject
extends AbstractUnitaryDataObject
implements DataObject,
ComplexListInterface {
    private static final List<MetadataField> ALL_FIELDS = Arrays.asList(new MetadataField("DataObjectProfile", new ComplexListMetadataKind(StringType.class, false), 2, 3), new MetadataField("DataObjectSystemId", new ComplexListMetadataKind(StringType.class, false), 1, 2, 3), new MetadataField("DataObjectGroupSystemId", new ComplexListMetadataKind(StringType.class, false), 1, 2, 3), new MetadataField("Relationship", new ComplexListMetadataKind(Relationship.class, true), 1, 2, 3), new MetadataField("DataObjectGroupReferenceId", new ComplexListMetadataKind(StringType.class, false), 1), new MetadataField("DataObjectGroupId", new ComplexListMetadataKind(StringType.class, false), 1, 2, 3), new MetadataField("DataObjectVersion", new ComplexListMetadataKind(StringType.class, false), 1, 2, 3), new MetadataField("PersistentIdentifier", new ComplexListMetadataKind(PersistentIdentifier.class, true), 3), new MetadataField("DataObjectUse", new ComplexListMetadataKind(StringType.class, false), 3), new MetadataField("DataObjectNumber", new ComplexListMetadataKind(IntegerType.class, false), 3), new MetadataField("Uri", new ComplexListMetadataKind(StringType.class, false), 1, 2, 3), new MetadataField("MessageDigest", new ComplexListMetadataKind(DigestType.class, false), 1, 2, 3), new MetadataField("Size", new ComplexListMetadataKind(IntegerType.class, false), 1, 2, 3), new MetadataField("Compressed", new ComplexListMetadataKind(StringType.class, false), 1, 2, 3), new MetadataField("FormatIdentification", new ComplexListMetadataKind(FormatIdentification.class, false), 1, 2, 3), new MetadataField("FileInfo", new ComplexListMetadataKind(FileInfo.class, false), 1, 2, 3), new MetadataField("Metadata", new ComplexListMetadataKind(Metadata.class, false), 1, 2, 3), new MetadataField("OtherMetadata", new ComplexListMetadataKind(AnyXMLListType.class, false), 1, 2, 3));
    @ComplexListMetadataMap(sedaVersion={SedaVersion.V2_1})
    public static final Map<String, ComplexListMetadataKind> METADATA_MAP_V1 = BinaryDataObject.createMetadataMapForVersion(1);
    @ComplexListMetadataMap(sedaVersion={SedaVersion.V2_2})
    public static final Map<String, ComplexListMetadataKind> METADATA_MAP_V2 = BinaryDataObject.createMetadataMapForVersion(2);
    @ComplexListMetadataMap(sedaVersion={SedaVersion.V2_3})
    public static final Map<String, ComplexListMetadataKind> METADATA_MAP_V3 = BinaryDataObject.createMetadataMapForVersion(3);
    @JsonIgnore
    private DataObjectGroup dataObjectGroup;
    private static final String SHA512_ALGORITHM = "SHA-512";
    private static final long SMALL_FILE_THRESHOLD = 0x200000L;

    private static LinkedHashMap<String, ComplexListMetadataKind> createMetadataMapForVersion(int version2) {
        LinkedHashMap<String, ComplexListMetadataKind> map = new LinkedHashMap<String, ComplexListMetadataKind>();
        for (MetadataField field : ALL_FIELDS) {
            if (!field.isForVersion(version2)) continue;
            map.put(field.key, field.kind);
        }
        return map;
    }

    @Override
    @JsonIgnore
    public LinkedHashMap<String, ComplexListMetadataKind> getMetadataMap() throws SEDALibException {
        return (LinkedHashMap)ComplexListInterface.getMetadataMap(this.getClass());
    }

    @Override
    @JsonIgnore
    public boolean isNotExpandable() {
        return ComplexListInterface.isNotExpandable(this.getClass());
    }

    public BinaryDataObject() {
        this(null, null, null, null);
    }

    public BinaryDataObject(DataObjectPackage dataObjectPackage) {
        this(dataObjectPackage, null, null, null);
    }

    private void addFilenameMetadata(Path path, String explicitFilename) {
        String nameValue;
        String string = explicitFilename != null ? explicitFilename : (nameValue = path != null ? path.getFileName().toString() : null);
        if (nameValue == null) {
            return;
        }
        FileInfo fileInfo = new FileInfo();
        try {
            fileInfo.addNewMetadata("Filename", nameValue);
        }
        catch (SEDALibException sEDALibException) {
            // empty catch block
        }
        this.metadataList.add(fileInfo);
    }

    public BinaryDataObject(DataObjectPackage dataObjectPackage, Path path, String explicitFilename, String dataObjectVersion) {
        super(dataObjectPackage);
        if (dataObjectVersion != null) {
            this.metadataList.add(new StringType("DataObjectVersion", dataObjectVersion));
        }
        this.addFilenameMetadata(path, explicitFilename);
        this.onDiskPath = path != null ? path.toAbsolutePath().normalize() : null;
    }

    public BinaryDataObject(DataObjectPackage dataObjectPackage, String xmlData) throws SEDALibException {
        this(dataObjectPackage);
        this.fromSedaXmlFragments(xmlData);
    }

    private static String getExtension(String fileName) {
        if (fileName == null) {
            return "";
        }
        int i = fileName.lastIndexOf(46);
        return i < 0 ? "seda" : fileName.substring(i + 1);
    }

    private static byte[] computeDigest(MessageDigest digest, Path path) throws SEDALibException {
        byte[] byArray;
        block9: {
            long size = Files.size(path);
            if (size <= 0x200000L) {
                byte[] all = Files.readAllBytes(path);
                digest.update(all);
                return digest.digest();
            }
            FileChannel channel = FileChannel.open(path, StandardOpenOption.READ);
            try {
                MappedByteBuffer buffer = channel.map(FileChannel.MapMode.READ_ONLY, 0L, size);
                digest.update(buffer);
                byArray = digest.digest();
                if (channel == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (channel != null) {
                        try {
                            channel.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new SEDALibException(String.format("Impossible de calculer le hash du fichier [%s]", path), e);
                }
            }
            channel.close();
        }
        return byArray;
    }

    private static String bytesToHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        for (byte b : bytes) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }

    public static String getDigestSha512(Path path) throws SEDALibException {
        try {
            MessageDigest digest = MessageDigest.getInstance(SHA512_ALGORITHM);
            byte[] hash = BinaryDataObject.computeDigest(digest, path);
            return BinaryDataObject.bytesToHex(hash);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SEDALibException("Impossible de mobiliser l'algorithme de hashage SHA-512", e);
        }
    }

    private void updateFileInfo(FileTime lastModifiedTime) throws SEDALibException {
        String filename;
        FileInfo fileInfo = this.getMetadataFileInfo();
        if (fileInfo == null) {
            fileInfo = new FileInfo();
            filename = null;
        } else {
            filename = fileInfo.getSimpleMetadata("Filename");
        }
        if (filename == null) {
            filename = this.onDiskPath.getFileName().toString();
            fileInfo.addNewMetadata("Filename", filename);
        }
        fileInfo.addNewMetadata("LastModified", lastModifiedTime.toString());
        this.addMetadata(fileInfo);
    }

    private IdentificationResult identifyFormat(SEDALibProgressLogger logger, Path path) {
        try {
            return DroidIdentifier.getInstance().getIdentificationResult(path);
        }
        catch (SEDALibException e) {
            SEDALibProgressLogger.doProgressLogWithoutInterruption(logger, 50, "sedalib: impossible de faire l'identification Droid pour le fichier [" + path + "]", e);
            return null;
        }
    }

    public void extractTechnicalElements(SEDALibProgressLogger sedaLibProgressLogger) throws SEDALibException {
        FileTime lastModifiedTime;
        long size;
        try {
            size = Files.size(this.onDiskPath);
            lastModifiedTime = Files.getLastModifiedTime(this.onDiskPath, new LinkOption[0]);
        }
        catch (IOException e) {
            throw new SEDALibException("Impossible d'obtenir les infos techniques pour le fichier [" + this.onDiskPath.toString() + "]", e);
        }
        this.updateFileInfo(lastModifiedTime);
        this.addMetadata(new DigestType("MessageDigest", BinaryDataObject.getDigestSha512(this.onDiskPath), SHA512_ALGORITHM));
        this.addMetadata(new IntegerType("Size", size));
        IdentificationResult idResult = this.identifyFormat(sedaLibProgressLogger, this.onDiskPath);
        if (idResult != null) {
            this.addMetadata(new FormatIdentification(idResult.getName(), idResult.getMimeType(), idResult.getPuid(), null));
        } else {
            this.addMetadata(new FormatIdentification("Unknown", null, "UNKNOWN", null));
        }
    }

    private String undefined(String a) {
        return a == null ? "non d\u00e9fini" : a;
    }

    private void finalizeUri() throws SEDALibException {
        FileInfo fileInfo = this.getMetadataFileInfo();
        String tmpUri = "content/" + this.inDataPackageObjectId;
        if (fileInfo != null) {
            String tmp = fileInfo.getSimpleMetadata("Filename");
            tmpUri = tmpUri + (String)(tmp != null ? "." + BinaryDataObject.getExtension(tmp) : "");
        }
        this.addMetadata(new StringType("Uri", tmpUri));
    }

    @Override
    public void toSedaXml(SEDAXMLStreamWriter xmlWriter, SEDALibProgressLogger sedaLibProgressLogger) throws InterruptedException, SEDALibException {
        this.finalizeUri();
        super.toSedaXml(xmlWriter, sedaLibProgressLogger);
    }

    public static BinaryDataObject fromSedaXml(SEDAXMLEventReader xmlReader, DataObjectPackage dataObjectPackage, SEDALibProgressLogger sedaLibProgressLogger) throws SEDALibException, InterruptedException {
        BinaryDataObject bdo = new BinaryDataObject();
        return BinaryDataObject.importUnitaryDataObjectPackageIdElementFromSedaXml(bdo, xmlReader, dataObjectPackage, sedaLibProgressLogger) ? bdo : null;
    }

    @JsonIgnore
    public FileInfo getMetadataFileInfo() {
        return (FileInfo)this.getFirstNamedMetadata("FileInfo");
    }

    @JsonIgnore
    public StringType getMetadataUri() {
        return (StringType)this.getFirstNamedMetadata("Uri");
    }

    @JsonIgnore
    public IntegerType getMetadataSize() {
        return (IntegerType)this.getFirstNamedMetadata("Size");
    }

    @JsonIgnore
    public DigestType getMetadataMessageDigest() {
        return (DigestType)this.getFirstNamedMetadata("MessageDigest");
    }

    @JsonIgnore
    public FormatIdentification getMetadataFormatIdentification() {
        return (FormatIdentification)this.getFirstNamedMetadata("FormatIdentification");
    }

    private static class MetadataField {
        final String key;
        final ComplexListMetadataKind kind;
        final Set<Integer> versions;

        MetadataField(String key, ComplexListMetadataKind kind, Integer ... supportedVersions) {
            this.key = key;
            this.kind = kind;
            this.versions = new HashSet<Integer>(Arrays.asList(supportedVersions));
        }

        boolean isForVersion(int version2) {
            return this.versions.contains(version2);
        }
    }
}

