/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.sedalib.core;

import com.fasterxml.jackson.annotation.JsonIgnore;
import fr.gouv.vitam.tools.sedalib.core.ArchiveUnit;
import fr.gouv.vitam.tools.sedalib.core.DataObjectPackage;
import fr.gouv.vitam.tools.sedalib.core.DataObjectPackageElement;
import java.util.ArrayList;
import java.util.List;

public class ArchiveUnitRefList
extends DataObjectPackageElement {
    @JsonIgnore
    private List<ArchiveUnit> archiveUnitList;
    private List<String> inDataObjectPackageIdList;

    public ArchiveUnitRefList() {
    }

    public ArchiveUnitRefList(DataObjectPackage dataObjectPackage) {
        super(dataObjectPackage);
        this.archiveUnitList = null;
        this.inDataObjectPackageIdList = null;
    }

    public List<String> getInDataObjectPackageIdList() {
        if (this.inDataObjectPackageIdList != null) {
            return this.inDataObjectPackageIdList;
        }
        if (this.archiveUnitList == null) {
            this.inDataObjectPackageIdList = new ArrayList<String>(0);
        } else {
            this.inDataObjectPackageIdList = new ArrayList<String>(this.archiveUnitList.size());
            for (ArchiveUnit au : this.archiveUnitList) {
                this.inDataObjectPackageIdList.add(au.inDataPackageObjectId);
            }
        }
        this.archiveUnitList = null;
        return this.inDataObjectPackageIdList;
    }

    public void setInDataObjectPackageIdList(List<String> inDataObjectPackageIdList) {
        this.inDataObjectPackageIdList = inDataObjectPackageIdList;
        this.archiveUnitList = null;
    }

    @JsonIgnore
    public List<ArchiveUnit> getArchiveUnitList() {
        if (this.archiveUnitList != null) {
            return this.archiveUnitList;
        }
        if (this.inDataObjectPackageIdList == null) {
            this.archiveUnitList = new ArrayList<ArchiveUnit>(0);
        } else {
            this.archiveUnitList = new ArrayList<ArchiveUnit>(this.inDataObjectPackageIdList.size());
            for (String inSipId : this.inDataObjectPackageIdList) {
                this.archiveUnitList.add(this.getDataObjectPackage().getArchiveUnitById(inSipId));
            }
        }
        this.inDataObjectPackageIdList = null;
        return this.archiveUnitList;
    }

    @JsonIgnore
    public void setArchiveUnitList(List<ArchiveUnit> archiveUnitList) {
        this.archiveUnitList = archiveUnitList;
        this.inDataObjectPackageIdList = null;
    }

    public void add(ArchiveUnit archiveUnit) {
        this.getArchiveUnitList().add(archiveUnit);
    }

    public void addById(String inDataObjectPackageId) {
        this.getInDataObjectPackageIdList().add(inDataObjectPackageId);
    }

    public void remove(ArchiveUnit archiveUnit) {
        this.getArchiveUnitList().remove(archiveUnit);
    }

    public void replace(ArchiveUnit originArchiveUnit, ArchiveUnit newArchiveUnit) {
        List<ArchiveUnit> listAu = this.getArchiveUnitList();
        for (int i = 0; i < listAu.size(); ++i) {
            if (listAu.get(i) != originArchiveUnit) continue;
            listAu.set(i, newArchiveUnit);
            return;
        }
    }

    public void removeById(String inDataObjectPackageId) {
        this.getInDataObjectPackageIdList().remove(inDataObjectPackageId);
    }

    @JsonIgnore
    public int getCount() {
        if (this.inDataObjectPackageIdList != null) {
            return this.inDataObjectPackageIdList.size();
        }
        if (this.archiveUnitList != null) {
            return this.archiveUnitList.size();
        }
        return 0;
    }
}

