/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.sedalib.core;

import com.fasterxml.jackson.annotation.JsonIgnore;
import fr.gouv.vitam.tools.sedalib.core.ArchiveUnitRefList;
import fr.gouv.vitam.tools.sedalib.core.DataObject;
import fr.gouv.vitam.tools.sedalib.core.DataObjectGroup;
import fr.gouv.vitam.tools.sedalib.core.DataObjectPackage;
import fr.gouv.vitam.tools.sedalib.core.DataObjectPackageIdElement;
import fr.gouv.vitam.tools.sedalib.core.DataObjectRefList;
import fr.gouv.vitam.tools.sedalib.metadata.ArchiveUnitProfile;
import fr.gouv.vitam.tools.sedalib.metadata.SEDAMetadata;
import fr.gouv.vitam.tools.sedalib.metadata.content.Content;
import fr.gouv.vitam.tools.sedalib.metadata.management.Management;
import fr.gouv.vitam.tools.sedalib.utils.SEDALibException;
import fr.gouv.vitam.tools.sedalib.utils.SEDALibProgressLogger;
import fr.gouv.vitam.tools.sedalib.xml.SEDAXMLEventReader;
import fr.gouv.vitam.tools.sedalib.xml.SEDAXMLStreamWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public class ArchiveUnit
extends DataObjectPackageIdElement {
    private String archiveUnitProfileXmlData = null;
    @JsonIgnore
    private ArchiveUnitProfile archiveUnitProfile = null;
    private String managementXmlData = null;
    @JsonIgnore
    private Management management = null;
    private String contentXmlData = null;
    @JsonIgnore
    private Content content = null;
    private ArchiveUnitRefList childrenAuList;
    private DataObjectRefList dataObjectRefList;

    public ArchiveUnit() {
        this.childrenAuList = new ArchiveUnitRefList(null);
        this.dataObjectRefList = new DataObjectRefList(null);
    }

    public ArchiveUnit(DataObjectPackage dataObjectPackage) {
        super(dataObjectPackage);
        this.childrenAuList = new ArchiveUnitRefList(dataObjectPackage);
        this.dataObjectRefList = new DataObjectRefList(dataObjectPackage);
        if (dataObjectPackage != null) {
            try {
                dataObjectPackage.addArchiveUnit(this);
            }
            catch (SEDALibException sEDALibException) {
                // empty catch block
            }
        }
    }

    public String getArchiveUnitProfileXmlData() {
        if (this.archiveUnitProfileXmlData != null) {
            return this.archiveUnitProfileXmlData;
        }
        if (this.archiveUnitProfile == null) {
            return null;
        }
        this.archiveUnitProfileXmlData = this.archiveUnitProfile.toString();
        return this.archiveUnitProfileXmlData;
    }

    public void setArchiveUnitProfileXmlData(String archiveUnitProfileXmlData) {
        this.archiveUnitProfileXmlData = archiveUnitProfileXmlData;
        this.archiveUnitProfile = null;
    }

    public ArchiveUnitProfile getArchiveUnitProfile() throws SEDALibException {
        if (this.archiveUnitProfile != null) {
            this.archiveUnitProfileXmlData = null;
            return this.archiveUnitProfile;
        }
        if (this.archiveUnitProfileXmlData == null) {
            return null;
        }
        this.archiveUnitProfile = (ArchiveUnitProfile)SEDAMetadata.fromString(this.archiveUnitProfileXmlData, ArchiveUnitProfile.class);
        this.archiveUnitProfileXmlData = null;
        return this.archiveUnitProfile;
    }

    public void setArchiveUnitProfile(ArchiveUnitProfile archiveUnitProfile) {
        this.archiveUnitProfileXmlData = null;
        this.archiveUnitProfile = archiveUnitProfile;
    }

    public String getManagementXmlData() {
        if (this.managementXmlData != null) {
            return this.managementXmlData;
        }
        if (this.management == null) {
            return null;
        }
        this.managementXmlData = this.management.toString();
        return this.managementXmlData;
    }

    public void setManagementXmlData(String managementXmlData) {
        this.managementXmlData = managementXmlData;
        this.management = null;
    }

    public Management getManagement() throws SEDALibException {
        if (this.management != null) {
            this.managementXmlData = null;
            return this.management;
        }
        if (this.managementXmlData == null) {
            return null;
        }
        this.management = (Management)SEDAMetadata.fromString(this.managementXmlData, Management.class);
        this.managementXmlData = null;
        return this.management;
    }

    public void setManagement(Management management) {
        this.managementXmlData = null;
        this.management = management;
    }

    public String getContentXmlData() {
        if (this.contentXmlData != null) {
            return this.contentXmlData;
        }
        if (this.content == null) {
            return null;
        }
        this.contentXmlData = this.content.toString();
        return this.contentXmlData;
    }

    @JsonIgnore
    public boolean isContentSEDACompliant() {
        if (this.content != null) {
            return true;
        }
        if (this.contentXmlData == null) {
            return false;
        }
        try {
            this.content = (Content)SEDAMetadata.fromString(this.contentXmlData, Content.class);
            this.contentXmlData = null;
        }
        catch (SEDALibException e) {
            return false;
        }
        return true;
    }

    @JsonIgnore
    public String getFilteredContentExportString() {
        if (this.getDataObjectPackage().getExportMetadataList() == null) {
            return this.getContentXmlData();
        }
        if (this.content != null) {
            return this.content.filteredToString(this.getDataObjectPackage().getExportMetadataList());
        }
        try {
            this.content = (Content)SEDAMetadata.fromString(this.contentXmlData, Content.class);
            this.contentXmlData = null;
        }
        catch (SEDALibException e) {
            return this.contentXmlData;
        }
        return this.content.filteredToString(this.getDataObjectPackage().getExportMetadataList());
    }

    public void setContentXmlData(String contentXmlData) {
        this.contentXmlData = contentXmlData;
        this.content = null;
    }

    public Content getContent() throws SEDALibException {
        if (this.content != null) {
            this.contentXmlData = null;
            return this.content;
        }
        if (this.contentXmlData == null) {
            return null;
        }
        this.content = (Content)SEDAMetadata.fromString(this.contentXmlData, Content.class);
        this.contentXmlData = null;
        return this.content;
    }

    public void setContent(Content content) {
        this.contentXmlData = null;
        this.content = content;
    }

    public void setDefaultContent(String title, String descriptionLevel) throws SEDALibException {
        Content c = new Content();
        c.addNewMetadata("DescriptionLevel", descriptionLevel);
        c.addNewMetadata("Title", title);
        this.setContent(c);
    }

    public void addDataObjectById(String inDataPackageObjectId) {
        this.dataObjectRefList.addById(inDataPackageObjectId);
    }

    public void removeDataObjectById(String inDataPackageObjectId) {
        this.dataObjectRefList.removeById(inDataPackageObjectId);
    }

    public void addChildArchiveUnit(ArchiveUnit au) {
        this.childrenAuList.add(au);
    }

    public void removeChildArchiveUnit(ArchiveUnit au) {
        this.childrenAuList.remove(au);
    }

    public void replaceChildArchiveUnit(ArchiveUnit originAu, ArchiveUnit newAu) {
        this.childrenAuList.replace(originAu, newAu);
    }

    public void addChildArchiveUnitById(String inDataPackageObjectId) {
        this.childrenAuList.addById(inDataPackageObjectId);
    }

    public void removeChildArchiveUnitById(String inDataPackageObjectId) {
        this.childrenAuList.removeById(inDataPackageObjectId);
    }

    public void toSedaXml(SEDAXMLStreamWriter xmlWriter, boolean imbricateFlag, SEDALibProgressLogger sedaLibProgressLogger) throws SEDALibException, InterruptedException {
        try {
            if (imbricateFlag) {
                if (this.getDataObjectPackage().isTouchedInDataObjectPackageId(this.inDataPackageObjectId)) {
                    xmlWriter.writeStartElement("ArchiveUnit");
                    xmlWriter.writeAttribute("id", this.getDataObjectPackage().getNextRefID());
                    xmlWriter.writeElementValue("ArchiveUnitRefId", this.inDataPackageObjectId);
                    xmlWriter.writeEndElement();
                    return;
                }
                this.getDataObjectPackage().addTouchedInDataObjectPackageId(this.inDataPackageObjectId);
            }
            xmlWriter.writeStartElement("ArchiveUnit");
            xmlWriter.writeAttribute("id", this.inDataPackageObjectId);
            xmlWriter.writeRawXMLBlockIfNotEmpty(this.getArchiveUnitProfileXmlData());
            xmlWriter.writeRawXMLBlockIfNotEmpty(this.getManagementXmlData());
            if (this.getDataObjectPackage().getExportMetadataList() != null && !this.isContentSEDACompliant()) {
                SEDALibProgressLogger.doProgressLog(sedaLibProgressLogger, 10, "sedalib: l'ArchiveUnit [" + this.inDataPackageObjectId + "] ne peut \u00eatre filtr\u00e9e car son Content n'est pas conforme SEDA. Le Content est \u00e9crit tel quel.", null);
                xmlWriter.writeRawXMLBlockIfNotEmpty(this.getContentXmlData());
            } else {
                xmlWriter.writeRawXMLBlockIfNotEmpty(this.getFilteredContentExportString());
            }
            for (ArchiveUnit au : this.childrenAuList.getArchiveUnitList()) {
                if (!imbricateFlag) {
                    xmlWriter.writeStartElement("ArchiveUnit");
                    xmlWriter.writeAttribute("id", this.getDataObjectPackage().getNextRefID());
                    xmlWriter.writeElementValue("ArchiveUnitRefId", au.inDataPackageObjectId);
                    xmlWriter.writeEndElement();
                    continue;
                }
                au.toSedaXml(xmlWriter, true, sedaLibProgressLogger);
            }
            for (DataObject dataObject : this.dataObjectRefList.getDataObjectList()) {
                xmlWriter.writeStartElement("DataObjectReference");
                if (dataObject instanceof DataObjectGroup) {
                    xmlWriter.writeElementValue("DataObjectGroupReferenceId", dataObject.getInDataObjectPackageId());
                } else {
                    xmlWriter.writeElementValue("DataObjectReferenceId", dataObject.getInDataObjectPackageId());
                }
                xmlWriter.writeEndElement();
            }
            xmlWriter.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new SEDALibException("Erreur d'\u00e9criture XML de l'ArchiveUnit [" + this.inDataPackageObjectId + "]", e);
        }
        int counter = this.getDataObjectPackage().getNextInOutCounter();
        SEDALibProgressLogger.doProgressLogIfStep(sedaLibProgressLogger, 30, counter, "sedalib: " + counter + " m\u00e9tadonn\u00e9es ArchiveUnit export\u00e9es");
    }

    public String toSedaXmlFragments() {
        StringBuilder sb = new StringBuilder();
        String tmp = this.getArchiveUnitProfileXmlData();
        if (tmp != null) {
            sb.append(tmp).append("\n");
        }
        if ((tmp = this.getManagementXmlData()) != null) {
            sb.append(tmp).append("\n");
        }
        if ((tmp = this.getContentXmlData()) != null) {
            sb.append(tmp).append("\n");
        }
        return sb.toString().trim();
    }

    public static String idFromSedaXml(SEDAXMLEventReader xmlReader, DataObjectPackage dataObjectPackage, SEDALibProgressLogger sedaLibProgressLogger) throws SEDALibException, InterruptedException {
        ArchiveUnit au = null;
        try {
            String tmp = xmlReader.peekAttributeBlockIfNamed("ArchiveUnit", "id");
            if (tmp != null) {
                xmlReader.nextUsefullEvent();
                if (xmlReader.peekBlockIfNamed("ArchiveUnitRefId")) {
                    tmp = xmlReader.nextMandatoryValue("ArchiveUnitRefId");
                    xmlReader.endBlockNamed("ArchiveUnit");
                    return tmp;
                }
                au = new ArchiveUnit();
                au.inDataPackageObjectId = tmp;
                dataObjectPackage.addArchiveUnit(au);
                au.setArchiveUnitProfileXmlData(xmlReader.nextBlockAsStringIfNamed("ArchiveUnitProfile"));
                au.setManagementXmlData(xmlReader.nextBlockAsStringIfNamed("Management"));
                au.setContentXmlData(xmlReader.nextBlockAsStringIfNamed("Content"));
                while ((tmp = xmlReader.peekName()) != null) {
                    switch (tmp) {
                        case "ArchiveUnit": {
                            String subAuId = ArchiveUnit.idFromSedaXml(xmlReader, dataObjectPackage, sedaLibProgressLogger);
                            au.addChildArchiveUnitById(subAuId);
                            break;
                        }
                        case "DataObjectReference": {
                            xmlReader.nextUsefullEvent();
                            tmp = xmlReader.peekName();
                            if (tmp == null) break;
                            switch (tmp) {
                                case "DataObjectReferenceId": {
                                    tmp = xmlReader.nextValueIfNamed("DataObjectReferenceId");
                                    DataObject dataObject = dataObjectPackage.getDataObjectById(tmp);
                                    if (dataObject == null || dataObject instanceof DataObjectGroup) {
                                        throw new SEDALibException("Erreur de r\u00e9f\u00e9rence DataObjectReferenceId [" + tmp + "]");
                                    }
                                    au.addDataObjectById(tmp);
                                    break;
                                }
                                case "DataObjectGroupReferenceId": {
                                    tmp = xmlReader.nextValueIfNamed("DataObjectGroupReferenceId");
                                    DataObject dataObject = dataObjectPackage.getDataObjectById(tmp);
                                    if (!(dataObject instanceof DataObjectGroup)) {
                                        throw new SEDALibException("Erreur de r\u00e9f\u00e9rence DataObjectGroupReferenceId [" + tmp + "]");
                                    }
                                    au.addDataObjectById(tmp);
                                    break;
                                }
                                default: {
                                    throw new SEDALibException("Element DataObjectReference mal form\u00e9");
                                }
                            }
                            xmlReader.endBlockNamed("DataObjectReference");
                            break;
                        }
                        default: {
                            throw new SEDALibException("Element ArchiveUnit [" + au.inDataPackageObjectId + "] mal form\u00e9, \u00e9l\u00e9ment [" + tmp + "] anormal");
                        }
                    }
                }
                xmlReader.endBlockNamed("ArchiveUnit");
            }
        }
        catch (XMLStreamException e) {
            throw new SEDALibException("Erreur de lecture XML de l'ArchiveUnit" + (String)(au != null ? " [" + au.inDataPackageObjectId + "]" : ""), e);
        }
        if (au == null) {
            return null;
        }
        int counter = dataObjectPackage.getNextInOutCounter();
        SEDALibProgressLogger.doProgressLogIfStep(sedaLibProgressLogger, 30, counter, "sedalib: " + counter + " m\u00e9tadonn\u00e9es ArchiveUnit import\u00e9es");
        return au.inDataPackageObjectId;
    }

    public void fromSedaXmlFragments(String fragments) throws SEDALibException {
        ArchiveUnit au = new ArchiveUnit();
        try (ByteArrayInputStream bais = new ByteArrayInputStream(fragments.getBytes(StandardCharsets.UTF_8));
             SEDAXMLEventReader xmlReader = new SEDAXMLEventReader(bais, true);){
            xmlReader.nextUsefullEvent();
            au.setArchiveUnitProfileXmlData(xmlReader.nextBlockAsStringIfNamed("ArchiveUnitProfile"));
            au.setManagementXmlData(xmlReader.nextBlockAsStringIfNamed("Management"));
            au.setContentXmlData(xmlReader.nextBlockAsStringIfNamed("Content"));
            XMLEvent event = xmlReader.xmlReader.peek();
            if (!event.isEndDocument()) {
                throw new SEDALibException("Il y a des champs ill\u00e9gaux");
            }
        }
        catch (SEDALibException | IOException | XMLStreamException e) {
            throw new SEDALibException("Erreur de lecture XML de l'ArchiveUnit [" + this.inDataPackageObjectId + "]", e);
        }
        if (au.getContentXmlData() == null) {
            throw new SEDALibException("La partie <Content> de l'ArchiveUnit est obligatoire");
        }
        this.setArchiveUnitProfileXmlData(au.getArchiveUnitProfileXmlData());
        this.setManagementXmlData(au.getManagementXmlData());
        this.setContentXmlData(au.getContentXmlData());
    }

    public String toString() {
        String result = null;
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
             SEDAXMLStreamWriter xmlWriter = new SEDAXMLStreamWriter(baos, 2);){
            this.toSedaXml(xmlWriter, true, null);
            xmlWriter.flush();
            result = baos.toString(StandardCharsets.UTF_8);
            if (result.startsWith("\n")) {
                result = result.substring(1);
            }
        }
        catch (SEDALibException | IOException | XMLStreamException e) {
            result = super.toString();
        }
        catch (InterruptedException e) {
            result = super.toString();
            Thread.currentThread().interrupt();
        }
        return result;
    }

    public ArchiveUnitRefList getChildrenAuList() {
        return this.childrenAuList;
    }

    public void setChildrenAuList(ArchiveUnitRefList childrenAuList) {
        this.childrenAuList = childrenAuList;
    }

    public DataObjectRefList getDataObjectRefList() {
        return this.dataObjectRefList;
    }

    public void setDataObjectRefList(DataObjectRefList dataObjectRefList) {
        this.dataObjectRefList = dataObjectRefList;
    }

    @JsonIgnore
    public DataObjectGroup getTheDataObjectGroup() {
        if (this.dataObjectRefList.getCount() != 1) {
            return null;
        }
        DataObject tmp = this.dataObjectRefList.getDataObjectList().get(0);
        if (tmp instanceof DataObjectGroup) {
            return (DataObjectGroup)tmp;
        }
        return null;
    }

    private ArchiveUnit searchDOGArchiveUnit(DataObjectGroup dataObjectGroup) {
        for (Map.Entry<String, ArchiveUnit> e : this.getDataObjectPackage().getAuInDataObjectPackageIdMap().entrySet()) {
            DataObjectGroup dog = e.getValue().getTheDataObjectGroup();
            if (dog == null || !dog.equals(dataObjectGroup)) continue;
            return e.getValue();
        }
        return null;
    }

    public boolean removeEmptyDataObjectGroup() {
        DataObjectGroup dog = this.getTheDataObjectGroup();
        if (dog != null) {
            if (dog.getPhysicalDataObjectList().size() + dog.getBinaryDataObjectList().size() != 0) {
                return false;
            }
            this.removeDataObjectById(dog.getInDataObjectPackageId());
            if (this.searchDOGArchiveUnit(dog) == null) {
                this.getDataObjectPackage().getDogInDataObjectPackageIdMap().remove(dog.getInDataObjectPackageId());
            }
        }
        return true;
    }

    @Override
    public void setDataObjectPackage(DataObjectPackage dataObjectPackage) {
        super.setDataObjectPackage(dataObjectPackage);
        this.childrenAuList.setDataObjectPackage(dataObjectPackage);
        this.dataObjectRefList.setDataObjectPackage(dataObjectPackage);
    }
}

