/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.sedalib.core;

import com.fasterxml.jackson.annotation.JsonIgnore;
import fr.gouv.vitam.tools.sedalib.core.DataObjectPackage;
import fr.gouv.vitam.tools.sedalib.core.GlobalMetadata;
import fr.gouv.vitam.tools.sedalib.core.seda.SedaContext;
import fr.gouv.vitam.tools.sedalib.core.seda.SedaVersion;
import fr.gouv.vitam.tools.sedalib.utils.SEDALibException;
import fr.gouv.vitam.tools.sedalib.utils.SEDALibProgressLogger;
import fr.gouv.vitam.tools.sedalib.xml.SEDAXMLEventReader;
import fr.gouv.vitam.tools.sedalib.xml.SEDAXMLStreamWriter;
import fr.gouv.vitam.tools.sedalib.xml.SEDAXMLValidator;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import javax.xml.validation.Schema;

public class ArchiveTransfer {
    private GlobalMetadata globalMetadata = null;
    private DataObjectPackage dataObjectPackage;

    public ArchiveTransfer() {
        this.setDataObjectPackage(new DataObjectPackage());
    }

    @JsonIgnore
    public String getDescription() {
        return "ArchiveTransfer\n" + this.getDataObjectPackage().getDescription();
    }

    private void exportStartDocument(SEDAXMLStreamWriter xmlWriter) throws SEDALibException {
        try {
            xmlWriter.writeStartDocument();
            xmlWriter.writeStartElement("ArchiveTransfer");
            xmlWriter.writeNamespace("xlink", "http://www.w3.org/1999/xlink");
            xmlWriter.writeNamespace("pr", "info:lc/xmlns/premis-v2");
            SedaVersion version2 = SedaContext.getVersion();
            switch (version2) {
                case V2_1: {
                    xmlWriter.writeDefaultNamespace("fr:gouv:culture:archivesdefrance:seda:v2.1");
                    xmlWriter.writeNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
                    xmlWriter.writeAttribute("xsi", "http://www.w3.org/2001/XMLSchema-instance", "schemaLocation", "fr:gouv:culture:archivesdefrance:seda:v2.1 seda-2.1-main.xsd");
                    break;
                }
                case V2_2: {
                    xmlWriter.writeDefaultNamespace("fr:gouv:culture:archivesdefrance:seda:v2.2");
                    xmlWriter.writeNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
                    xmlWriter.writeAttribute("xsi", "http://www.w3.org/2001/XMLSchema-instance", "schemaLocation", "fr:gouv:culture:archivesdefrance:seda:v2.2 seda-2.2-main.xsd");
                    break;
                }
                case V2_3: {
                    xmlWriter.writeDefaultNamespace("fr:gouv:culture:archivesdefrance:seda:v2.3");
                    xmlWriter.writeNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
                    xmlWriter.writeAttribute("xsi", "http://www.w3.org/2001/XMLSchema-instance", "schemaLocation", "fr:gouv:culture:archivesdefrance:seda:v2.3 seda-2.3-main.xsd");
                    break;
                }
                default: {
                    throw new SEDALibException("Version [" + SedaContext.getVersion() + "] sans sch\u00e9ma", null);
                }
            }
            xmlWriter.setXmlId(true);
        }
        catch (XMLStreamException e) {
            throw new SEDALibException("Erreur d'\u00e9criture XML du d\u00e9but du manifest", e);
        }
    }

    private void exportHeader(SEDAXMLStreamWriter xmlWriter) throws SEDALibException {
        try {
            xmlWriter.writeElementValueIfNotEmpty("Comment", this.globalMetadata.comment);
            if (this.globalMetadata.isNowFlag()) {
                this.globalMetadata.date = SEDAXMLStreamWriter.getStringFromDateTime(null);
            }
            xmlWriter.writeElementValueIfNotEmpty("Date", this.globalMetadata.date);
            xmlWriter.writeElementValueIfNotEmpty("MessageIdentifier", this.globalMetadata.messageIdentifier);
            xmlWriter.writeElementValueIfNotEmpty("ArchivalAgreement", this.globalMetadata.archivalAgreement);
            xmlWriter.writeRawXMLBlockIfNotEmpty(this.globalMetadata.codeListVersionsXmlData);
        }
        catch (XMLStreamException e) {
            throw new SEDALibException("Erreur d'\u00e9criture XML d'ent\u00eate du manifest", e);
        }
    }

    private void exportFooter(SEDAXMLStreamWriter xmlWriter) throws SEDALibException {
        try {
            xmlWriter.writeElementValueIfNotEmpty("TransferRequestReplyIdentifier", this.globalMetadata.transferRequestReplyIdentifier);
            xmlWriter.writeStartElement("ArchivalAgency");
            xmlWriter.writeElementValue("Identifier", this.globalMetadata.archivalAgencyIdentifier);
            xmlWriter.writeRawXMLBlockIfNotEmpty(this.globalMetadata.transferringAgencyOrganizationDescriptiveMetadataXmlData);
            xmlWriter.writeEndElement();
            xmlWriter.writeStartElement("TransferringAgency");
            xmlWriter.writeElementValue("Identifier", this.globalMetadata.transferringAgencyIdentifier);
            xmlWriter.writeRawXMLBlockIfNotEmpty(this.globalMetadata.transferringAgencyOrganizationDescriptiveMetadataXmlData);
            xmlWriter.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new SEDALibException("Erreur d'\u00e9criture XML de la fin du manifest", e);
        }
    }

    private void exportEndDocument(SEDAXMLStreamWriter xmlWriter) throws SEDALibException {
        try {
            xmlWriter.writeEndElement();
            xmlWriter.writeEndDocument();
            xmlWriter.flush();
        }
        catch (XMLStreamException e) {
            throw new SEDALibException("Erreur d'\u00e9criture XML de la cloture du manifest", e);
        }
    }

    public void toSedaXml(SEDAXMLStreamWriter xmlWriter, boolean imbricateFlag, SEDALibProgressLogger sedaLibProgressLogger) throws SEDALibException, InterruptedException {
        this.exportStartDocument(xmlWriter);
        this.exportHeader(xmlWriter);
        this.dataObjectPackage.toSedaXml(xmlWriter, imbricateFlag, sedaLibProgressLogger);
        this.exportFooter(xmlWriter);
        this.exportEndDocument(xmlWriter);
    }

    private static void importStartDocument(SEDAXMLEventReader xmlReader) throws SEDALibException {
        try {
            XMLEvent event = xmlReader.nextUsefullEvent();
            if (!event.isStartDocument()) {
                throw new SEDALibException("Pas de document XML");
            }
            if (!xmlReader.nextBlockIfNamed("ArchiveTransfer")) {
                throw new SEDALibException("Pas d'\u00e9l\u00e9ment ArchiveTransfer");
            }
        }
        catch (XMLStreamException e) {
            throw new SEDALibException("Erreur de lecture XML", e);
        }
    }

    private static void importHeader(SEDAXMLEventReader xmlReader, ArchiveTransfer archiveTransfer) throws SEDALibException {
        try {
            archiveTransfer.globalMetadata.comment = xmlReader.nextValueIfNamed("Comment");
            archiveTransfer.globalMetadata.date = xmlReader.nextMandatoryValue("Date");
            archiveTransfer.globalMetadata.messageIdentifier = xmlReader.nextMandatoryValue("MessageIdentifier");
            if (xmlReader.peekBlockIfNamed("Signature")) {
                throw new SEDALibException("L'\u00e9l\u00e9ment Signature dans l'ArchiveTransfer n'est pas support\u00e9");
            }
            archiveTransfer.globalMetadata.archivalAgreement = xmlReader.nextValueIfNamed("ArchivalAgreement");
            archiveTransfer.globalMetadata.codeListVersionsXmlData = xmlReader.nextMandatoryBlockAsString("CodeListVersions");
        }
        catch (SEDALibException | XMLStreamException e) {
            throw new SEDALibException("Erreur de lecture XML d'ent\u00eate du manifest", e);
        }
    }

    private static void importFooter(SEDAXMLEventReader xmlReader, ArchiveTransfer archiveTransfer) throws SEDALibException {
        try {
            if (xmlReader.peekBlockIfNamed("RelatedTransferReference")) {
                throw new SEDALibException("L'\u00e9l\u00e9ment RelatedTransferReference dans l'ArchiveTransfer n'est pas support\u00e9");
            }
            archiveTransfer.globalMetadata.transferRequestReplyIdentifier = xmlReader.nextValueIfNamed("TransferRequestReplyIdentifier");
            if (!xmlReader.nextBlockIfNamed("ArchivalAgency")) {
                throw new SEDALibException("El\u00e9ment ArchivalAgency obligatoire");
            }
            archiveTransfer.globalMetadata.archivalAgencyIdentifier = xmlReader.nextMandatoryValue("Identifier");
            archiveTransfer.globalMetadata.archivalAgencyOrganizationDescriptiveMetadataXmlData = xmlReader.nextBlockAsStringIfNamed("OrganizationDescriptiveMetadata");
            xmlReader.endBlockNamed("ArchivalAgency");
            if (!xmlReader.nextBlockIfNamed("TransferringAgency")) {
                throw new SEDALibException("El\u00e9ment TransferingAgency Obligatoire");
            }
            archiveTransfer.globalMetadata.transferringAgencyIdentifier = xmlReader.nextMandatoryValue("Identifier");
            archiveTransfer.globalMetadata.transferringAgencyOrganizationDescriptiveMetadataXmlData = xmlReader.nextBlockAsStringIfNamed("OrganizationDescriptiveMetadata");
            xmlReader.endBlockNamed("TransferringAgency");
        }
        catch (SEDALibException | XMLStreamException e) {
            throw new SEDALibException("Erreur de lecture de la fin du manifest", e);
        }
    }

    private static void importEndDocument(SEDAXMLEventReader xmlReader) throws SEDALibException {
        try {
            xmlReader.endBlockNamed("ArchiveTransfer");
            XMLEvent event = xmlReader.peekUsefullEvent();
            if (!event.isEndDocument()) {
                throw new SEDALibException("Pas de fin attendue du document XML");
            }
        }
        catch (SEDALibException | XMLStreamException e) {
            throw new SEDALibException("Erreur de lecture de la cloture du manifest", e);
        }
    }

    public static ArchiveTransfer fromSedaXml(SEDAXMLEventReader xmlReader, String rootDir, SEDALibProgressLogger sedaLibProgressLogger) throws SEDALibException, InterruptedException {
        ArchiveTransfer.importStartDocument(xmlReader);
        ArchiveTransfer archiveTransfer = new ArchiveTransfer();
        archiveTransfer.setGlobalMetadata(new GlobalMetadata());
        ArchiveTransfer.importHeader(xmlReader, archiveTransfer);
        archiveTransfer.setDataObjectPackage(DataObjectPackage.fromSedaXml(xmlReader, rootDir, sedaLibProgressLogger));
        ArchiveTransfer.importFooter(xmlReader, archiveTransfer);
        ArchiveTransfer.importEndDocument(xmlReader);
        SEDALibProgressLogger.doProgressLog(sedaLibProgressLogger, 20, "sedalib: ArchiveTransfer import\u00e9", null);
        return archiveTransfer;
    }

    public void sedaSchemaValidate(SEDALibProgressLogger sedaLibProgressLogger) throws SEDALibException, InterruptedException {
        String manifest;
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
             SEDAXMLStreamWriter ixsw = new SEDAXMLStreamWriter(baos, 2);){
            this.toSedaXml(ixsw, true, sedaLibProgressLogger);
            manifest = baos.toString(StandardCharsets.UTF_8);
        }
        catch (IOException | XMLStreamException e) {
            throw new SEDALibException("Echec d'\u00e9criture XML du manifest", e);
        }
        SEDAXMLValidator sedaXMLvalidator = new SEDAXMLValidator();
        Schema sedaSchema = SEDAXMLValidator.getSEDASchema();
        sedaXMLvalidator.checkWithXSDSchema(manifest, sedaSchema);
    }

    public void sedaProfileValidate(String profileFileName, SEDALibProgressLogger sedaLibProgressLogger) throws SEDALibException, InterruptedException {
        String manifest;
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
             SEDAXMLStreamWriter ixsw = new SEDAXMLStreamWriter(baos, 2);){
            this.toSedaXml(ixsw, true, sedaLibProgressLogger);
            manifest = baos.toString(StandardCharsets.UTF_8);
        }
        catch (IOException | XMLStreamException e) {
            throw new SEDALibException("Echec d'\u00e9criture XML du manifest", e);
        }
        SEDAXMLValidator sedaXMLvalidator = new SEDAXMLValidator();
        Schema sedaSchema = profileFileName.endsWith(".rng") ? sedaXMLvalidator.getSchemaFromRNGFile(profileFileName) : sedaXMLvalidator.getSchemaFromXSDFile(profileFileName);
        if (profileFileName.endsWith(".rng")) {
            sedaXMLvalidator.checkWithRNGSchema(manifest, sedaSchema);
        } else {
            sedaXMLvalidator.checkWithXSDSchema(manifest, sedaSchema);
        }
    }

    public GlobalMetadata getGlobalMetadata() {
        return this.globalMetadata;
    }

    public void setGlobalMetadata(GlobalMetadata globalMetadata) {
        this.globalMetadata = globalMetadata;
    }

    public DataObjectPackage getDataObjectPackage() {
        return this.dataObjectPackage;
    }

    public void setDataObjectPackage(DataObjectPackage dataObjectPackage) {
        this.dataObjectPackage = dataObjectPackage;
    }
}

