/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.sedalib.core;

import com.fasterxml.jackson.annotation.JsonIgnore;
import fr.gouv.vitam.tools.sedalib.core.DataObjectPackage;
import fr.gouv.vitam.tools.sedalib.core.GlobalMetadata;
import fr.gouv.vitam.tools.sedalib.metadata.Operation;
import fr.gouv.vitam.tools.sedalib.metadata.SEDAMetadata;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.InnerIdentifierType;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.StringType;
import fr.gouv.vitam.tools.sedalib.utils.SEDALibException;
import fr.gouv.vitam.tools.sedalib.utils.SEDALibProgressLogger;
import fr.gouv.vitam.tools.sedalib.xml.SEDAXMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public class ArchiveDeliveryRequestReply {
    private GlobalMetadata globalMetadata = null;
    private DataObjectPackage dataObjectPackage;
    private StringType replyCode;
    private Operation operation;
    private StringType messageRequestIdentifier;
    private StringType authorizationRequestReplyIdentifier;
    private StringType unitIdentifier;
    private InnerIdentifierType archivalAgency;
    private InnerIdentifierType requester;

    public ArchiveDeliveryRequestReply() {
        this.setDataObjectPackage(new DataObjectPackage());
    }

    @JsonIgnore
    public String getDescription() {
        return "ArchiveDeliveryRequestReply\n" + this.getDataObjectPackage().getDescription();
    }

    private static void importStartDocument(SEDAXMLEventReader xmlReader) throws SEDALibException {
        try {
            XMLEvent event = xmlReader.nextUsefullEvent();
            if (!event.isStartDocument()) {
                throw new SEDALibException("Pas de document XML");
            }
            if (!xmlReader.nextBlockIfNamed("ArchiveDeliveryRequestReply")) {
                throw new SEDALibException("Pas d'\u00e9l\u00e9ment ArchiveTransfer");
            }
        }
        catch (XMLStreamException e) {
            throw new SEDALibException("Erreur de lecture XML", e);
        }
    }

    private static void importHeader(SEDAXMLEventReader xmlReader, ArchiveDeliveryRequestReply archiveDeliveryRequestReply, SEDALibProgressLogger sedaLibProgressLogger) throws InterruptedException {
        try {
            archiveDeliveryRequestReply.globalMetadata.comment = xmlReader.nextValueIfNamed("Comment");
            archiveDeliveryRequestReply.globalMetadata.date = xmlReader.nextMandatoryValue("Date");
            archiveDeliveryRequestReply.globalMetadata.messageIdentifier = xmlReader.nextMandatoryValue("MessageIdentifier");
            if (xmlReader.peekBlockIfNamed("Signature")) {
                throw new SEDALibException("L'\u00e9l\u00e9ment Signature dans l'ArchiveTransfer n'est pas support\u00e9");
            }
            archiveDeliveryRequestReply.globalMetadata.archivalAgreement = xmlReader.nextValueIfNamed("ArchivalAgreement");
            archiveDeliveryRequestReply.globalMetadata.codeListVersionsXmlData = xmlReader.nextMandatoryBlockAsString("CodeListVersions");
        }
        catch (SEDALibException | XMLStreamException e) {
            SEDALibProgressLogger.doProgressLog(sedaLibProgressLogger, 20, "sedalib: l'ent\u00eate n'est pas conforme \u00e0 un ArchiveDeliveryRequestReply, mais la tentative d'analyse continue", null);
            archiveDeliveryRequestReply.globalMetadata = null;
        }
    }

    private static void importFooter(SEDAXMLEventReader xmlReader, ArchiveDeliveryRequestReply archiveDeliveryRequestReply, SEDALibProgressLogger sedaLibProgressLogger) throws SEDALibException, InterruptedException {
        try {
            SEDALibProgressLogger.doProgressLog(sedaLibProgressLogger, 10, "sedalib: d\u00e9but du bloc de fin sp\u00e9cifique du DIP", null);
            if (xmlReader.peekBlockIfNamed("ReplyCode")) {
                archiveDeliveryRequestReply.replyCode = (StringType)SEDAMetadata.fromSedaXml(xmlReader, StringType.class);
                SEDALibProgressLogger.doProgressLog(sedaLibProgressLogger, 10, archiveDeliveryRequestReply.replyCode.toString(), null);
            }
            if (xmlReader.peekBlockIfNamed("Operation")) {
                archiveDeliveryRequestReply.operation = (Operation)SEDAMetadata.fromSedaXml(xmlReader, Operation.class);
                SEDALibProgressLogger.doProgressLog(sedaLibProgressLogger, 10, archiveDeliveryRequestReply.operation.toString(), null);
            }
            if (xmlReader.peekBlockIfNamed("MessageRequestIdentifier")) {
                archiveDeliveryRequestReply.messageRequestIdentifier = (StringType)SEDAMetadata.fromSedaXml(xmlReader, StringType.class);
                SEDALibProgressLogger.doProgressLog(sedaLibProgressLogger, 10, archiveDeliveryRequestReply.messageRequestIdentifier.toString(), null);
            }
            if (xmlReader.peekBlockIfNamed("AuthorizationRequestReplyIdentifier")) {
                archiveDeliveryRequestReply.authorizationRequestReplyIdentifier = (StringType)SEDAMetadata.fromSedaXml(xmlReader, StringType.class);
                SEDALibProgressLogger.doProgressLog(sedaLibProgressLogger, 10, archiveDeliveryRequestReply.authorizationRequestReplyIdentifier.toString(), null);
            }
            if (xmlReader.peekBlockIfNamed("UnitIdentifier")) {
                archiveDeliveryRequestReply.unitIdentifier = (StringType)SEDAMetadata.fromSedaXml(xmlReader, StringType.class);
                SEDALibProgressLogger.doProgressLog(sedaLibProgressLogger, 10, archiveDeliveryRequestReply.unitIdentifier.toString(), null);
            }
            if (xmlReader.peekBlockIfNamed("ArchivalAgency")) {
                archiveDeliveryRequestReply.archivalAgency = (InnerIdentifierType)SEDAMetadata.fromSedaXml(xmlReader, InnerIdentifierType.class);
                SEDALibProgressLogger.doProgressLog(sedaLibProgressLogger, 10, archiveDeliveryRequestReply.archivalAgency.toString(), null);
            }
            if (xmlReader.peekBlockIfNamed("Requester")) {
                archiveDeliveryRequestReply.requester = (InnerIdentifierType)SEDAMetadata.fromSedaXml(xmlReader, InnerIdentifierType.class);
                SEDALibProgressLogger.doProgressLog(sedaLibProgressLogger, 10, archiveDeliveryRequestReply.requester.toString(), null);
            }
            SEDALibProgressLogger.doProgressLog(sedaLibProgressLogger, 10, "sedalib: fin du bloc de fin sp\u00e9cifique du DIP", null);
        }
        catch (SEDALibException | XMLStreamException e) {
            throw new SEDALibException("Erreur de lecture de la fin du manifest", e);
        }
    }

    private static void importEndDocument(SEDAXMLEventReader xmlReader, ArchiveDeliveryRequestReply archiveDeliveryRequestReply) throws SEDALibException {
        try {
            xmlReader.endBlockNamed("ArchiveDeliveryRequestReply");
            XMLEvent event = xmlReader.peekUsefullEvent();
            if (!event.isEndDocument()) {
                throw new SEDALibException("Pas de fin attendue du document XML");
            }
        }
        catch (SEDALibException | XMLStreamException e) {
            throw new SEDALibException("Erreur de lecture de la cloture du manifest", e);
        }
    }

    public static ArchiveDeliveryRequestReply fromSedaXml(SEDAXMLEventReader xmlReader, String rootDir, SEDALibProgressLogger sedaLibProgressLogger) throws SEDALibException, InterruptedException {
        ArchiveDeliveryRequestReply.importStartDocument(xmlReader);
        ArchiveDeliveryRequestReply archiveDeliveryRequestReply = new ArchiveDeliveryRequestReply();
        archiveDeliveryRequestReply.setGlobalMetadata(new GlobalMetadata());
        ArchiveDeliveryRequestReply.importHeader(xmlReader, archiveDeliveryRequestReply, sedaLibProgressLogger);
        archiveDeliveryRequestReply.setDataObjectPackage(DataObjectPackage.fromSedaXml(xmlReader, rootDir, sedaLibProgressLogger));
        ArchiveDeliveryRequestReply.importFooter(xmlReader, archiveDeliveryRequestReply, sedaLibProgressLogger);
        ArchiveDeliveryRequestReply.importEndDocument(xmlReader, archiveDeliveryRequestReply);
        SEDALibProgressLogger.doProgressLog(sedaLibProgressLogger, 20, "sedalib: archiveDeliveryRequestReply import\u00e9", null);
        return archiveDeliveryRequestReply;
    }

    public GlobalMetadata getGlobalMetadata() {
        return this.globalMetadata;
    }

    public void setGlobalMetadata(GlobalMetadata globalMetadata) {
        this.globalMetadata = globalMetadata;
    }

    public DataObjectPackage getDataObjectPackage() {
        return this.dataObjectPackage;
    }

    public void setDataObjectPackage(DataObjectPackage dataObjectPackage) {
        this.dataObjectPackage = dataObjectPackage;
    }
}

