/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.sedalib.core;

import com.fasterxml.jackson.annotation.JsonIgnore;
import fr.gouv.vitam.tools.sedalib.core.DataObject;
import fr.gouv.vitam.tools.sedalib.core.DataObjectGroup;
import fr.gouv.vitam.tools.sedalib.core.DataObjectPackage;
import fr.gouv.vitam.tools.sedalib.core.DataObjectPackageIdElement;
import fr.gouv.vitam.tools.sedalib.metadata.SEDAMetadata;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.ComplexListInterface;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.StringType;
import fr.gouv.vitam.tools.sedalib.utils.SEDALibException;
import fr.gouv.vitam.tools.sedalib.utils.SEDALibProgressLogger;
import fr.gouv.vitam.tools.sedalib.xml.SEDAXMLEventReader;
import fr.gouv.vitam.tools.sedalib.xml.SEDAXMLStreamWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public abstract class AbstractUnitaryDataObject
extends DataObjectPackageIdElement
implements DataObject,
ComplexListInterface {
    protected List<SEDAMetadata> metadataList = new ArrayList<SEDAMetadata>(10);
    @JsonIgnore
    DataObjectGroup dataObjectGroup = null;

    @Override
    public List<SEDAMetadata> getMetadataList() {
        return this.metadataList;
    }

    @Override
    public void setMetadataList(List<SEDAMetadata> metadataList) {
        this.metadataList = metadataList;
    }

    @Override
    @JsonIgnore
    public String getXmlElementName() {
        return this.getClass().getSimpleName();
    }

    public AbstractUnitaryDataObject() {
        this(null);
    }

    public AbstractUnitaryDataObject(DataObjectPackage dataObjectPackage) {
        super(dataObjectPackage);
        if (dataObjectPackage != null) {
            try {
                dataObjectPackage.addDataObjectPackageIdElement(this);
            }
            catch (SEDALibException sEDALibException) {
                // empty catch block
            }
        }
    }

    @Override
    public void toSedaXml(SEDAXMLStreamWriter xmlWriter, SEDALibProgressLogger sedaLibProgressLogger) throws InterruptedException, SEDALibException {
        try {
            xmlWriter.writeStartElement(this.getXmlElementName());
            xmlWriter.writeAttributeIfNotEmpty("id", this.inDataPackageObjectId);
            this.toSedaXmlMetadataList(xmlWriter);
            xmlWriter.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new SEDALibException("Erreur d'\u00e9criture XML du " + this.getXmlElementName() + " [" + this.inDataPackageObjectId + "]", e);
        }
        int counter = this.getDataObjectPackage().getNextInOutCounter();
        SEDALibProgressLogger.doProgressLogIfStep(sedaLibProgressLogger, 30, counter, "sedalib: " + counter + " m\u00e9tadonn\u00e9es DataObject export\u00e9es");
    }

    private String extractXmlFragments(String xml, String elementName) {
        if (xml == null || xml.isEmpty()) {
            return null;
        }
        int endIndex = (xml = xml.replaceFirst("<" + elementName + " .*>", "")).lastIndexOf("</" + elementName + ">");
        return endIndex > 0 ? xml.substring(1, endIndex - 1) : null;
    }

    @Override
    public String toSedaXmlFragments() throws SEDALibException {
        String sedaXml;
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            try (SEDAXMLStreamWriter xmlWriter = new SEDAXMLStreamWriter(baos, 2);){
                this.toSedaXml(xmlWriter, null);
            }
            sedaXml = baos.toString(StandardCharsets.UTF_8);
        }
        catch (SEDALibException | IOException | XMLStreamException e) {
            throw new SEDALibException("Erreur interne", e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SEDALibException("Interruption", e);
        }
        return this.extractXmlFragments(sedaXml, this.getXmlElementName());
    }

    private void setFromXmlContent(SEDAXMLEventReader xmlReader) throws SEDALibException {
        try {
            this.metadataList = new ArrayList<SEDAMetadata>(18);
            this.fillFromSedaXmlMetadataList(xmlReader);
        }
        catch (SEDALibException e) {
            throw new SEDALibException("Erreur de lecture XML du " + this.getXmlElementName(), e);
        }
    }

    public static boolean importUnitaryDataObjectPackageIdElementFromSedaXml(AbstractUnitaryDataObject udo, SEDAXMLEventReader xmlReader, DataObjectPackage dataObjectPackage, SEDALibProgressLogger sedaLibProgressLogger) throws SEDALibException, InterruptedException {
        try {
            String tmp = xmlReader.peekAttributeBlockIfNamed(udo.getXmlElementName(), "id");
            if (tmp == null) {
                return false;
            }
            udo.inDataPackageObjectId = tmp;
            dataObjectPackage.addDataObjectPackageIdElement(udo);
            xmlReader.nextUsefullEvent();
            udo.setFromXmlContent(xmlReader);
            xmlReader.endBlockNamed(udo.getXmlElementName());
        }
        catch (XMLStreamException e) {
            throw new SEDALibException("Erreur de lecture XML du " + udo.getXmlElementName() + (String)(udo.inDataPackageObjectId != null ? " [" + udo.inDataPackageObjectId + "]" : ""), e);
        }
        StringType dataObjectGroupId = (StringType)udo.getFirstNamedMetadata("DataObjectGroupId");
        StringType dataObjectGroupReferenceId = (StringType)udo.getFirstNamedMetadata("DataObjectGroupReferenceId");
        if (dataObjectGroupId != null && dataObjectGroupReferenceId != null) {
            throw new SEDALibException("El\u00e9ments DataObjectGroupReferenceId et DataObjectGroupId incompatibles");
        }
        if (dataObjectGroupId != null) {
            if (dataObjectPackage.getDataObjectGroupById(dataObjectGroupId.getValue()) != null) {
                throw new SEDALibException("El\u00e9ment DataObjectGroup [" + dataObjectGroupId.getValue() + "] d\u00e9j\u00e0 cr\u00e9\u00e9");
            }
            DataObjectGroup dog = new DataObjectGroup();
            dog.setInDataObjectPackageId(dataObjectGroupId.getValue());
            dataObjectPackage.addDataObjectGroup(dog);
            dog.addDataObject(udo);
            SEDALibProgressLogger.doProgressLog(sedaLibProgressLogger, 50, "sedalib: dataObjectGroup [" + dog.inDataPackageObjectId + "] cr\u00e9\u00e9 depuis " + udo.getXmlElementName() + " [" + udo.inDataPackageObjectId + "]", null);
        } else if (dataObjectGroupReferenceId != null) {
            DataObjectGroup dog = dataObjectPackage.getDataObjectGroupById(dataObjectGroupReferenceId.getValue());
            if (dog == null) {
                throw new SEDALibException("Erreur de r\u00e9f\u00e9rence au DataObjectGroup [" + dataObjectGroupReferenceId.getValue() + "]");
            }
            dog.addDataObject(udo);
        }
        udo.removeFirstNamedMetadata("DataObjectGroupReferenceId");
        udo.removeFirstNamedMetadata("DataObjectGroupId");
        int counter = dataObjectPackage.getNextInOutCounter();
        SEDALibProgressLogger.doProgressLogIfStep(sedaLibProgressLogger, 30, counter, "sedalib: " + counter + " m\u00e9tadonn\u00e9es DataObject import\u00e9es");
        return true;
    }

    @JsonIgnore
    public AbstractUnitaryDataObject getEmptySameAbstractUnitaryDataObjet() throws SEDALibException {
        try {
            return (AbstractUnitaryDataObject)this.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new SEDALibException("Type de DataObject [" + this.getClass() + "] non g\u00e9r\u00e9", e);
        }
    }

    @Override
    public void fromSedaXmlFragments(String fragments) throws SEDALibException {
        AbstractUnitaryDataObject udo = this.getEmptySameAbstractUnitaryDataObjet();
        try (ByteArrayInputStream bais = new ByteArrayInputStream(fragments.getBytes(StandardCharsets.UTF_8));
             SEDAXMLEventReader xmlReader = new SEDAXMLEventReader(bais, true);){
            xmlReader.nextUsefullEvent();
            udo.setFromXmlContent(xmlReader);
            XMLEvent event = xmlReader.xmlReader.peek();
            if (!event.isEndDocument()) {
                throw new SEDALibException("Il y a des champs ill\u00e9gaux");
            }
        }
        catch (SEDALibException | IOException | XMLStreamException e) {
            throw new SEDALibException("Erreur de lecture du " + this.getXmlElementName(), e);
        }
        this.metadataList = udo.metadataList;
    }

    @JsonIgnore
    public StringType getMetadataDataObjectVersion() {
        return (StringType)this.getFirstNamedMetadata("DataObjectVersion");
    }

    @Override
    public DataObjectGroup getDataObjectGroup() {
        return this.dataObjectGroup;
    }

    public void setDataObjectGroup(DataObjectGroup dataObjectGroup) {
        this.dataObjectGroup = dataObjectGroup;
    }
}

