/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.loopfs.spi;

import com.github.stephenc.javaisotools.loopfs.api.FileEntry;
import com.github.stephenc.javaisotools.loopfs.spi.AbstractFileSystem;
import com.github.stephenc.javaisotools.loopfs.spi.SeekableInput;
import com.github.stephenc.javaisotools.loopfs.spi.VolumeDescriptorSet;
import java.io.IOException;
import java.util.Iterator;

public abstract class AbstractBlockFileSystem<T extends FileEntry>
extends AbstractFileSystem<T> {
    private final int blockSize;
    private final int reservedBlocks;
    private VolumeDescriptorSet<T> volumeDescriptorSet;

    protected AbstractBlockFileSystem(SeekableInput seekable, boolean readOnly, int blockSize, int reservedBlocks) throws IOException {
        super(seekable, readOnly);
        if (blockSize <= 0) {
            throw new IllegalArgumentException("'blockSize' must be > 0");
        }
        if (reservedBlocks < 0) {
            throw new IllegalArgumentException("'reservedBlocks' must be >= 0");
        }
        this.blockSize = blockSize;
        this.reservedBlocks = reservedBlocks;
    }

    @Override
    public final Iterator<T> iterator() {
        this.ensureOpen();
        if (null == this.volumeDescriptorSet) {
            try {
                this.loadVolumeDescriptors();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        return this.iterator(this.volumeDescriptorSet.getRootEntry());
    }

    protected void loadVolumeDescriptors() throws IOException {
        byte[] buffer = new byte[this.blockSize];
        this.volumeDescriptorSet = this.createVolumeDescriptorSet();
        int block = this.reservedBlocks;
        while (this.readBlock(block, buffer) && !this.volumeDescriptorSet.deserialize(buffer)) {
            ++block;
        }
    }

    protected final boolean readBlock(long block, byte[] buffer) throws IOException {
        int bytesRead = this.readData(block * (long)this.blockSize, buffer, 0, this.blockSize);
        if (bytesRead <= 0) {
            return false;
        }
        if (this.blockSize != bytesRead) {
            throw new IOException("Could not deserialize a complete block");
        }
        return true;
    }

    protected final synchronized int readData(long startPos, byte[] buffer, int offset, int len) throws IOException {
        this.seek(startPos);
        return this.read(buffer, offset, len);
    }

    protected final VolumeDescriptorSet<T> getVolumeDescriptorSet() {
        return this.volumeDescriptorSet;
    }

    protected abstract Iterator<T> iterator(T var1);

    protected abstract VolumeDescriptorSet<T> createVolumeDescriptorSet();
}

