/*
 * Decompiled with CFR 0.152.
 */
package com.github.junrar.unpack.ppm;

import com.github.junrar.unpack.ppm.PPMContext;
import com.github.junrar.unpack.ppm.State;

public class StateRef {
    private int symbol;
    private int freq;
    private int successor;

    public int getSymbol() {
        return this.symbol;
    }

    public void setSymbol(int symbol2) {
        this.symbol = symbol2 & 0xFF;
    }

    public int getFreq() {
        return this.freq;
    }

    public void setFreq(int freq) {
        this.freq = freq & 0xFF;
    }

    public void incFreq(int dFreq) {
        this.freq = this.freq + dFreq & 0xFF;
    }

    public void decFreq(int dFreq) {
        this.freq = this.freq - dFreq & 0xFF;
    }

    public void setValues(State statePtr) {
        this.setFreq(statePtr.getFreq());
        this.setSuccessor(statePtr.getSuccessor());
        this.setSymbol(statePtr.getSymbol());
    }

    public int getSuccessor() {
        return this.successor;
    }

    public void setSuccessor(PPMContext successor) {
        this.setSuccessor(successor.getAddress());
    }

    public void setSuccessor(int successor) {
        this.successor = successor;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("State[");
        buffer.append("\n  symbol=");
        buffer.append(this.getSymbol());
        buffer.append("\n  freq=");
        buffer.append(this.getFreq());
        buffer.append("\n  successor=");
        buffer.append(this.getSuccessor());
        buffer.append("\n]");
        return buffer.toString();
    }
}

