/*
 * Copyright (c) 2012, 2018, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_en extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Moscow = new String[] {
               "Moscow Standard Time",
               "MSK",
               "Moscow Summer Time",
               "MSD",
               "Moscow Time",
               "MT",
            };
        final String[] Pakistan = new String[] {
               "Pakistan Standard Time",
               "PKT",
               "Pakistan Summer Time",
               "PKST",
               "Pakistan Time",
               "PKT",
            };
        final String[] JRE_AET = new String[] {
               "Australian Eastern Standard Time (New South Wales)",
               "AEST",
               "Australian Eastern Daylight Time (New South Wales)",
               "AEDT",
               "Australian Eastern Time (New South Wales)",
               "AET",
            };
        final String[] Magadan = new String[] {
               "Magadan Standard Time",
               "MAGT",
               "Magadan Summer Time",
               "MAGST",
               "Magadan Time",
               "MAGT",
            };
        final String[] Europe_Central = new String[] {
               "Central European Standard Time",
               "CET",
               "Central European Summer Time",
               "CEST",
               "Central European Time",
               "CET",
            };
        final String[] Acre = new String[] {
               "Acre Standard Time",
               "ACT",
               "Acre Summer Time",
               "ACST",
               "Acre Time",
               "ACT",
            };
        final String[] America_Eastern = new String[] {
               "Eastern Standard Time",
               "EST",
               "Eastern Daylight Time",
               "EDT",
               "Eastern Time",
               "ET",
            };
        final String[] JRE_ACT = new String[] {
               "Australian Central Standard Time (Northern Territory)",
               "ACST",
               "Australian Central Daylight Time (Northern Territory)",
               "ACDT",
               "Australian Central Time (Northern Territory)",
               "ACT",
            };
        final String[] Lord_Howe = new String[] {
               "Lord Howe Standard Time",
               "LHST",
               "Lord Howe Daylight Time",
               "LHDT",
               "Lord Howe Time",
               "LHT",
            };
        final String[] New_Zealand = new String[] {
               "New Zealand Standard Time",
               "NZST",
               "New Zealand Daylight Time",
               "NZDT",
               "New Zealand Time",
               "NZT",
            };
        final String[] Indian_Ocean = new String[] {
               "Indian Ocean Time",
               "IOT",
               "Indian Ocean Territory Summer Time",
               "IOST",
               "Indian Ocean Territory Time",
               "IOT",
            };
        final String[] Yakutsk = new String[] {
               "Yakutsk Standard Time",
               "YAKT",
               "Yakutsk Summer Time",
               "YAKST",
               "Yakutsk Time",
               "YAKT",
            };
        final String[] East_Timor = new String[] {
               "East Timor Time",
               "TLT",
               "Timor-Leste Summer Time",
               "TLST",
               "Timor-Leste Time",
               "TLT",
            };
        final String[] Kosrae = new String[] {
               "Kosrae Time",
               "KOST",
               "Kosrae Summer Time",
               "KOSST",
               "Kosrae Time",
               "KOST",
            };
        final String[] Europe_Eastern = new String[] {
               "Eastern European Standard Time",
               "EET",
               "Eastern European Summer Time",
               "EEST",
               "Eastern European Time",
               "EET",
            };
        final String[] Argentina_Western = new String[] {
               "Western Argentina Standard Time",
               "ART",
               "Western Argentina Summer Time",
               "ARST",
               "Western Argentina Time",
               "ART",
            };
        final String[] JRE_AGT = new String[] {
               "Argentine Time",
               "ART",
               "Argentine Summer Time",
               "ARST",
               "Argentine Time",
               "ART",
            };
        final String[] Ponape = new String[] {
               "Ponape Time",
               "PONT",
               "Pohnpei Summer Time",
               "PONST",
               "Ponape Time",
               "PONT",
            };
        final String[] Bolivia = new String[] {
               "Bolivia Time",
               "BOT",
               "Bolivia Summer Time",
               "BOST",
               "Bolivia Time",
               "BOT",
            };
        final String[] Pierre_Miquelon = new String[] {
               "St. Pierre & Miquelon Standard Time",
               "PMST",
               "St. Pierre & Miquelon Daylight Time",
               "PMDT",
               "St. Pierre & Miquelon Time",
               "PMT",
            };
        final String[] Indochina = new String[] {
               "Indochina Time",
               "ICT",
               "Indochina Summer Time",
               "ICST",
               "Indochina Time",
               "ICT",
            };
        final String[] Yekaterinburg = new String[] {
               "Yekaterinburg Standard Time",
               "YEKT",
               "Yekaterinburg Summer Time",
               "YEKST",
               "Yekaterinburg Time",
               "YEKT",
            };
        final String[] JRE_NET = new String[] {
               "Armenia Time",
               "AMT",
               "Armenia Summer Time",
               "AMST",
               "Armenia Time",
               "AMT",
            };
        final String[] Maldives = new String[] {
               "Maldives Time",
               "MVT",
               "Maldives Summer Time",
               "MVST",
               "Maldives Time",
               "MVT",
            };
        final String[] Tahiti = new String[] {
               "Tahiti Time",
               "TAHT",
               "Tahiti Summer Time",
               "TAHST",
               "Tahiti Time",
               "TAHT",
            };
        final String[] Wallis = new String[] {
               "Wallis & Futuna Time",
               "WFT",
               "Wallis & Futuna Summer Time",
               "WFST",
               "Wallis & Futuna Time",
               "WFT",
            };
        final String[] Africa_Southern = new String[] {
               "South Africa Standard Time",
               "SAST",
               "South Africa Summer Time",
               "SAST",
               "South Africa Time",
               "SAT",
            };
        final String[] Syowa = new String[] {
               "Syowa Time",
               "SYOT",
               "Syowa Summer Time",
               "SYOST",
               "Syowa Time",
               "SYOT",
            };
        final String[] Line_Islands = new String[] {
               "Line Islands Time",
               "LINT",
               "Line Is. Summer Time",
               "LINST",
               "Line Is. Time",
               "LINT",
            };
        final String[] Uzbekistan = new String[] {
               "Uzbekistan Standard Time",
               "UZT",
               "Uzbekistan Summer Time",
               "UZST",
               "Uzbekistan Time",
               "UZT",
            };
        final String[] Mongolia = new String[] {
               "Ulaanbaatar Standard Time",
               "ULAT",
               "Ulaanbaatar Summer Time",
               "ULAST",
               "Ulaanbaatar Time",
               "ULAT",
            };
        final String[] America_Central = new String[] {
               "Central Standard Time",
               "CST",
               "Central Daylight Time",
               "CDT",
               "Central Time",
               "CT",
            };
        final String[] Niue = new String[] {
               "Niue Time",
               "NUT",
               "Niue Summer Time",
               "NUST",
               "Niue Time",
               "NUT",
            };
        final String[] Wake = new String[] {
               "Wake Island Time",
               "WAKT",
               "Wake Summer Time",
               "WAKST",
               "Wake Time",
               "WAKT",
            };
        final String[] Falkland = new String[] {
               "Falkland Islands Standard Time",
               "FKT",
               "Falkland Islands Summer Time",
               "FKST",
               "Falkland Islands Time",
               "FKT",
            };
        final String[] Bhutan = new String[] {
               "Bhutan Time",
               "BTT",
               "Bhutan Summer Time",
               "BTST",
               "Bhutan Time",
               "BTT",
            };
        final String[] Apia = new String[] {
               "Apia Standard Time",
               "WSST",
               "Apia Daylight Time",
               "WSDT",
               "Apia Time",
               "WST",
            };
        final String[] Nauru = new String[] {
               "Nauru Time",
               "NRT",
               "Nauru Summer Time",
               "NRST",
               "Nauru Time",
               "NRT",
            };
        final String[] Kazakhstan_Western = new String[] {
               "West Kazakhstan Time",
               "AQTT",
               "Aqtau Summer Time",
               "AQTST",
               "Aqtau Time",
               "AQTT",
            };
        final String[] Christmas = new String[] {
               "Christmas Island Time",
               "CXT",
               "Christmas Island Summer Time",
               "CXST",
               "Christmas Island Time",
               "CIT",
            };
        final String[] JRE_PLT = new String[] {
               "Pakistan Time",
               "PKT",
               "Pakistan Summer Time",
               "PKST",
               "Pakistan Time",
               "PKT",
            };
        final String[] Reunion = new String[] {
               "R\u00e9union Time",
               "RET",
               "Reunion Summer Time",
               "REST",
               "Reunion Time",
               "RET",
            };
        final String[] Cocos = new String[] {
               "Cocos Islands Time",
               "CCT",
               "Cocos Islands Summer Time",
               "CCST",
               "Cocos Islands Time",
               "CCT",
            };
        final String[] Chatham = new String[] {
               "Chatham Standard Time",
               "CHAST",
               "Chatham Daylight Time",
               "CHADT",
               "Chatham Time",
               "CHAT",
            };
        final String[] JRE_Asia_Barnaul = new String[] {
               "Barnaul Standard Time",
               "GMT+07:00",
               "Barnaul Daylight Time",
               "GMT+07:00",
               "Barnaul Time",
               "GMT+07:00",
            };
        final String[] Vostok = new String[] {
               "Vostok Time",
               "VOST",
               "Vostok Summer Time",
               "VOSST",
               "Vostok Time",
               "VOST",
            };
        final String[] Argentina = new String[] {
               "Argentina Standard Time",
               "ART",
               "Argentina Summer Time",
               "ARST",
               "Argentina Time",
               "ART",
            };
        final String[] Gambier = new String[] {
               "Gambier Time",
               "GAMT",
               "Gambier Summer Time",
               "GAMST",
               "Gambier Time",
               "GAMT",
            };
        final String[] JRE_Asia_Srednekolymsk = new String[] {
               "Srednekolymsk Time",
               "SRET",
               "Srednekolymsk Daylight Time",
               "SREDT",
               "Srednekolymsk Time",
               "SRET",
            };
        final String[] JRE_MIT = new String[] {
               "West Samoa Standard Time",
               "WSST",
               "West Samoa Daylight Time",
               "WSDT",
               "West Samoa Time",
               "WST",
            };
        final String[] Galapagos = new String[] {
               "Galapagos Time",
               "GALT",
               "Galapagos Summer Time",
               "GALST",
               "Galapagos Time",
               "GALT",
            };
        final String[] Venezuela = new String[] {
               "Venezuela Time",
               "VET",
               "Venezuela Summer Time",
               "VEST",
               "Venezuela Time",
               "VET",
            };
        final String[] JRE_Europe_Istanbul = new String[] {
               "Eastern European Time",
               "EET",
               "Eastern European Summer Time",
               "EEST",
               "Eastern European Time",
               "EET",
            };
        final String[] Phoenix_Islands = new String[] {
               "Phoenix Islands Time",
               "PHOT",
               "Phoenix Is. Summer Time",
               "PHOST",
               "Phoenix Is. Time",
               "PHOT",
            };
        final String[] Cape_Verde = new String[] {
               "Cape Verde Standard Time",
               "CVT",
               "Cape Verde Summer Time",
               "CVST",
               "Cape Verde Time",
               "CVT",
            };
        final String[] JRE_Europe_Astrakhan = new String[] {
               "Astrakhan Standard Time",
               "GMT+04:00",
               "Astrakhan Standard Time",
               "GMT+04:00",
               "Astrakhan Time",
               "GMT+04:00",
            };
        final String[] Norfolk = new String[] {
               "Norfolk Island Time",
               "NFT",
               "Norfolk Summer Time",
               "NFST",
               "Norfolk Time",
               "NFT",
            };
        final String[] JRE_Asia_Urumqi = new String[] {
               "Xinjiang Standard Time",
               "XJT",
               "Xinjiang Daylight Time",
               "XJDT",
               "Xinjiang Time",
               "XJT",
            };
        final String[] Samoa = new String[] {
               "Samoa Standard Time",
               "SST",
               "Samoa Daylight Time",
               "SDT",
               "Samoa Time",
               "ST",
            };
        final String[] JRE_SystemV_HST10 = new String[] {
               "Hawaii Standard Time",
               "HST",
               "Hawaii Daylight Time",
               "HDT",
               "Hawaii Time",
               "HT",
            };
        final String[] Davis = new String[] {
               "Davis Time",
               "DAVT",
               "Davis Summer Time",
               "DAVST",
               "Davis Time",
               "DAVT",
            };
        final String[] Cuba = new String[] {
               "Cuba Standard Time",
               "CST",
               "Cuba Daylight Time",
               "CDT",
               "Cuba Time",
               "CT",
            };
        final String[] GMT = new String[] {
               "Greenwich Mean Time",
               "GMT",
               "Greenwich Mean Time",
               "GMT",
               "Greenwich Mean Time",
               "GMT",
            };
        final String[] Philippines = new String[] {
               "Philippine Standard Time",
               "PHT",
               "Philippine Summer Time",
               "PHST",
               "Philippine Time",
               "PHT",
            };
        final String[] French_Southern = new String[] {
               "French Southern & Antarctic Time",
               "TFT",
               "French Southern & Antarctic Lands Summer Time",
               "TFST",
               "French Southern & Antarctic Lands Time",
               "TFT",
            };
        final String[] New_Caledonia = new String[] {
               "New Caledonia Standard Time",
               "NCT",
               "New Caledonia Summer Time",
               "NCST",
               "New Caledonia Time",
               "NCT",
            };
        final String[] Brunei = new String[] {
               "Brunei Darussalam Time",
               "BNT",
               "Brunei Summer Time",
               "BNST",
               "Brunei Time",
               "BNT",
            };
        final String[] Iran = new String[] {
               "Iran Standard Time",
               "IRST",
               "Iran Daylight Time",
               "IRDT",
               "Iran Time",
               "IRT",
            };
        final String[] Tajikistan = new String[] {
               "Tajikistan Time",
               "TJT",
               "Tajikistan Summer Time",
               "TJST",
               "Tajikistan Time",
               "TJT",
            };
        final String[] Tonga = new String[] {
               "Tonga Standard Time",
               "TOT",
               "Tonga Summer Time",
               "TOST",
               "Tonga Time",
               "TOT",
            };
        final String[] Bangladesh = new String[] {
               "Bangladesh Standard Time",
               "BDT",
               "Bangladesh Summer Time",
               "BDST",
               "Bangladesh Time",
               "BDT",
            };
        final String[] Peru = new String[] {
               "Peru Standard Time",
               "PET",
               "Peru Summer Time",
               "PEST",
               "Peru Time",
               "PET",
            };
        final String[] JRE_EET = new String[] {
               "Eastern European Time",
               "EET",
               "Eastern European Summer Time",
               "EEST",
               "Eastern European Time",
               "EET",
            };
        final String[] JRE_CAT = new String[] {
               "Central African Time",
               "CAT",
               "Central African Summer Time",
               "CAST",
               "Central Africa Time",
               "CAT",
            };
        final String[] Greenland_Eastern = new String[] {
               "East Greenland Standard Time",
               "EGT",
               "East Greenland Summer Time",
               "EGST",
               "East Greenland Time",
               "EGT",
            };
        final String[] JRE_EAT = new String[] {
               "Eastern African Time",
               "EAT",
               "Eastern African Summer Time",
               "EAST",
               "Eastern Africa Time",
               "EAT",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Eastern Indonesia Time",
               "WIT",
               "East Indonesia Summer Time",
               "EIST",
               "East Indonesia Time",
               "WIT",
            };
        final String[] Kyrgystan = new String[] {
               "Kyrgyzstan Time",
               "KGT",
               "Kirgizstan Summer Time",
               "KGST",
               "Kirgizstan Time",
               "KGT",
            };
        final String[] JRE_ECT = new String[] {
               "Central European Time",
               "CET",
               "Central European Summer Time",
               "CEST",
               "Central European Time",
               "CET",
            };
        final String[] JRE_Pacific_Bougainville = new String[] {
               "Bougainville Standard Time",
               "BST",
               "Bougainville Daylight Time",
               "BST",
               "Bougainville Time",
               "BT",
            };
        final String[] Colombia = new String[] {
               "Colombia Standard Time",
               "COT",
               "Colombia Summer Time",
               "COST",
               "Colombia Time",
               "COT",
            };
        final String[] French_Guiana = new String[] {
               "French Guiana Time",
               "GFT",
               "French Guiana Summer Time",
               "GFST",
               "French Guiana Time",
               "GFT",
            };
        final String[] Australia_Eastern = new String[] {
               "Australian Eastern Standard Time",
               "AEST",
               "Australian Eastern Daylight Time",
               "AEDT",
               "Eastern Australia Time",
               "AET",
            };
        final String[] Chile = new String[] {
               "Chile Standard Time",
               "CLT",
               "Chile Summer Time",
               "CLST",
               "Chile Time",
               "CLT",
            };
        final String[] Gilbert_Islands = new String[] {
               "Gilbert Islands Time",
               "GILT",
               "Gilbert Is. Summer Time",
               "GILST",
               "Gilbert Is. Time",
               "GILT",
            };
        final String[] JRE_CET = new String[] {
               "Central European Time",
               "CET",
               "Central European Summer Time",
               "CEST",
               "Central European Time",
               "CET",
            };
        final String[] Irkutsk = new String[] {
               "Irkutsk Standard Time",
               "IRKT",
               "Irkutsk Summer Time",
               "IRKST",
               "Irkutsk Time",
               "IRKT",
            };
        final String[] Georgia = new String[] {
               "Georgia Standard Time",
               "GET",
               "Georgia Summer Time",
               "GEST",
               "Georgia Time",
               "GET",
            };
        final String[] Choibalsan = new String[] {
               "Choibalsan Standard Time",
               "CHOT",
               "Choibalsan Summer Time",
               "CHOST",
               "Choibalsan Time",
               "CHOT",
            };
        final String[] China = new String[] {
               "China Standard Time",
               "CST",
               "China Daylight Time",
               "CDT",
               "China Time",
               "CT",
            };
        final String[] Armenia = new String[] {
               "Armenia Standard Time",
               "AMT",
               "Armenia Summer Time",
               "AMST",
               "Armenia Time",
               "AMT",
            };
        final String[] JRE_Turkey = new String[] {
               "Eastern European Time",
               "EET",
               "Eastern European Summer Time",
               "EEST",
               "Eastern European Time",
               "EET",
            };
        final String[] Africa_Central = new String[] {
               "Central Africa Time",
               "CAT",
               "Central African Summer Time",
               "CAST",
               "Central Africa Time",
               "CAT",
            };
        final String[] Japan = new String[] {
               "Japan Standard Time",
               "JST",
               "Japan Daylight Time",
               "JDT",
               "Japan Time",
               "JT",
            };
        final String[] JRE_HST = new String[] {
               "Hawaii Standard Time",
               "HST",
               "Hawaii Daylight Time",
               "HDT",
               "Hawaii Time",
               "HT",
            };
        final String[] Taipei = new String[] {
               "Taipei Standard Time",
               "CST",
               "Taipei Daylight Time",
               "CDT",
               "Taipei Time",
               "CT",
            };
        final String[] Hovd = new String[] {
               "Hovd Standard Time",
               "HOVT",
               "Hovd Summer Time",
               "HOVST",
               "Hovd Time",
               "HOVT",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Australian Central Western Standard Time",
               "ACWST",
               "Australian Central Western Daylight Time",
               "ACWDT",
               "Australian Central Western Time",
               "ACWT",
            };
        final String[] Sakhalin = new String[] {
               "Sakhalin Standard Time",
               "SAKT",
               "Sakhalin Summer Time",
               "SAKST",
               "Sakhalin Time",
               "SAKT",
            };
        final String[] Paraguay = new String[] {
               "Paraguay Standard Time",
               "PYT",
               "Paraguay Summer Time",
               "PYST",
               "Paraguay Time",
               "PYT",
            };
        final String[] Casey = new String[] {
               "Casey Time",
               "AWST",
               "Australian Western Daylight Time",
               "AWDT",
               "Australian Western Time",
               "AWT",
            };
        final String[] Malaysia = new String[] {
               "Malaysia Time",
               "MYT",
               "Malaysia Summer Time",
               "MYST",
               "Malaysia Time",
               "MYT",
            };
        final String[] JRE_Asia_Tomsk = new String[] {
               "Tomsk Standard Time",
               "GMT+07:00",
               "Tomsk Daylight Time",
               "GMT+07:00",
               "Tomsk Time",
               "GMT+07:00",
            };
        final String[] JRE_BET = new String[] {
               "Brasilia Time",
               "BRT",
               "Brasilia Summer Time",
               "BRST",
               "Brasilia Time",
               "BRT",
            };
        final String[] JRE_Asia_Kashgar = new String[] {
               "Xinjiang Standard Time",
               "XJT",
               "Xinjiang Daylight Time",
               "XJDT",
               "Xinjiang Time",
               "XJT",
            };
        final String[] Mauritius = new String[] {
               "Mauritius Standard Time",
               "MUT",
               "Mauritius Summer Time",
               "MUST",
               "Mauritius Time",
               "MUT",
            };
        final String[] Africa_Eastern = new String[] {
               "East Africa Time",
               "EAT",
               "Eastern African Summer Time",
               "EAST",
               "Eastern Africa Time",
               "EAT",
            };
        final String[] Solomon = new String[] {
               "Solomon Islands Time",
               "SBT",
               "Solomon Is. Summer Time",
               "SBST",
               "Solomon Is. Time",
               "SBT",
            };
        final String[] Marshall_Islands = new String[] {
               "Marshall Islands Time",
               "MHT",
               "Marshall Islands Summer Time",
               "MHST",
               "Marshall Islands Time",
               "MHT",
            };
        final String[] JRE_Europe_Saratov = new String[] {
               "Saratov Standard Time",
               "GMT+04:00",
               "Saratov Standard Time",
               "GMT+04:00",
               "Saratov Time",
               "GMT+04:00",
            };
        final String[] Newfoundland = new String[] {
               "Newfoundland Standard Time",
               "NST",
               "Newfoundland Daylight Time",
               "NDT",
               "Newfoundland Time",
               "NT",
            };
        final String[] Afghanistan = new String[] {
               "Afghanistan Time",
               "AFT",
               "Afghanistan Summer Time",
               "AFST",
               "Afghanistan Time",
               "AFT",
            };
        final String[] Hong_Kong = new String[] {
               "Hong Kong Standard Time",
               "HKT",
               "Hong Kong Summer Time",
               "HKST",
               "Hong Kong Time",
               "HKT",
            };
        final String[] Atlantic = new String[] {
               "Atlantic Standard Time",
               "AST",
               "Atlantic Daylight Time",
               "ADT",
               "Atlantic Time",
               "AT",
            };
        final String[] Israel = new String[] {
               "Israel Standard Time",
               "IST",
               "Israel Daylight Time",
               "IDT",
               "Israel Time",
               "IT",
            };
        final String[] Indonesia_Central = new String[] {
               "Central Indonesia Time",
               "WITA",
               "Central Indonesia Summer Time",
               "CIST",
               "Central Indonesia Time",
               "WITA",
            };
        final String[] Omsk = new String[] {
               "Omsk Standard Time",
               "OMST",
               "Omsk Summer Time",
               "OMSST",
               "Omsk Time",
               "OMST",
            };
        final String[] Seychelles = new String[] {
               "Seychelles Time",
               "SCT",
               "Seychelles Summer Time",
               "SCST",
               "Seychelles Time",
               "SCT",
            };
        final String[] Uruguay = new String[] {
               "Uruguay Standard Time",
               "UYT",
               "Uruguay Summer Time",
               "UYST",
               "Uruguay Time",
               "UYT",
            };
        final String[] Nepal = new String[] {
               "Nepal Time",
               "NPT",
               "Nepal Summer Time",
               "NPST",
               "Nepal Time",
               "NPT",
            };
        final String[] Truk = new String[] {
               "Chuuk Time",
               "CHUT",
               "Chuuk Summer Time",
               "CHUST",
               "Chuuk Time",
               "CHUT",
            };
        final String[] Vanuatu = new String[] {
               "Vanuatu Standard Time",
               "VUT",
               "Vanuatu Summer Time",
               "VUST",
               "Vanuatu Time",
               "VUT",
            };
        final String[] Novosibirsk = new String[] {
               "Novosibirsk Standard Time",
               "NOVT",
               "Novosibirsk Summer Time",
               "NOVST",
               "Novosibirsk Time",
               "NOVT",
            };
        final String[] JRE_Europe_Kirov = new String[] {
               "Kirov Standard Time",
               "GMT+03:00",
               "Kirov Daylight Time",
               "GMT+03:00",
               "Kirov Time",
               "GMT+03:00",
            };
        final String[] Singapore = new String[] {
               "Singapore Standard Time",
               "SGT",
               "Singapore Summer Time",
               "SGST",
               "Singapore Time",
               "SGT",
            };
        final String[] JRE_BST = new String[] {
               "Bangladesh Time",
               "BDT",
               "Bangladesh Summer Time",
               "BDST",
               "Bangladesh Time",
               "BDT",
            };
        final String[] Azores = new String[] {
               "Azores Standard Time",
               "AZOT",
               "Azores Summer Time",
               "AZOST",
               "Azores Time",
               "AZOT",
            };
        final String[] Suriname = new String[] {
               "Suriname Time",
               "SRT",
               "Suriname Summer Time",
               "SRST",
               "Suriname Time",
               "SRT",
            };
        final String[] JRE_Asia_Famagusta = new String[] {
               "Eastern European Time",
               "EET",
               "Eastern European Summer Time",
               "EEST",
               "Eastern European Time",
               "EET",
            };
        final String[] JRE_MET = new String[] {
               "Middle Europe Time",
               "MET",
               "Middle Europe Summer Time",
               "MEST",
               "Middle Europe Time",
               "MET",
            };
        final String[] Krasnoyarsk = new String[] {
               "Krasnoyarsk Standard Time",
               "KRAT",
               "Krasnoyarsk Summer Time",
               "KRAST",
               "Krasnoyarsk Time",
               "KRAT",
            };
        final String[] Myanmar = new String[] {
               "Myanmar Time",
               "MMT",
               "Myanmar Summer Time",
               "MMST",
               "Myanmar Time",
               "MMT",
            };
        final String[] JRE_SST = new String[] {
               "Solomon Is. Time",
               "SBT",
               "Solomon Is. Summer Time",
               "SBST",
               "Solomon Is. Time",
               "SBT",
            };
        final String[] Amazon = new String[] {
               "Amazon Standard Time",
               "AMT",
               "Amazon Summer Time",
               "AMST",
               "Amazon Time",
               "AMT",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "East Kazakhstan Time",
               "ALMT",
               "Alma-Ata Summer Time",
               "ALMST",
               "Alma-Ata Time",
               "ALMT",
            };
        final String[] Fiji = new String[] {
               "Fiji Standard Time",
               "FJT",
               "Fiji Summer Time",
               "FJST",
               "Fiji Time",
               "FJT",
            };
        final String[] JRE_Antarctica_Palmer = new String[] {
               "Chile Time",
               "CLT",
               "Chile Summer Time",
               "CLST",
               "Chile Time",
               "CLT",
            };
        final String[] Kamchatka = new String[] {
               "Petropavlovsk-Kamchatski Standard Time",
               "PETT",
               "Petropavlovsk-Kamchatski Summer Time",
               "PETST",
               "Petropavlovsk-Kamchatski Time",
               "PETT",
            };
        final String[] JRE_America_Punta_Arenas = new String[] {
               "Punta Arenas Standard Time",
               "GMT-03:00",
               "Punta Arenas Standard Time",
               "GMT-03:00",
               "Punta Arenas Time",
               "GMT-03:00",
            };
        final String[] Tuvalu = new String[] {
               "Tuvalu Time",
               "TVT",
               "Tuvalu Summer Time",
               "TVST",
               "Tuvalu Time",
               "TVT",
            };
        final String[] JRE_ART = new String[] {
               "Eastern European Time",
               "EET",
               "Eastern European Summer Time",
               "EEST",
               "Eastern European Time",
               "EET",
            };
        final String[] Macquarie = new String[] {
               "Macquarie Island Time",
               "MIST",
               "Macquarie Island Daylight Time",
               "MIDT",
               "Macquarie Island Time",
               "MIST",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Hawaii-Aleutian Standard Time",
               "HAST",
               "Hawaii-Aleutian Daylight Time",
               "HADT",
               "Hawaii-Aleutian Time",
               "HAT",
            };
        final String[] Australia_Central = new String[] {
               "Australian Central Standard Time",
               "ACST",
               "Australian Central Daylight Time",
               "ACDT",
               "Central Australia Time",
               "ACT",
            };
        final String[] America_Pacific = new String[] {
               "Pacific Standard Time",
               "PST",
               "Pacific Daylight Time",
               "PDT",
               "Pacific Time",
               "PT",
            };
        final String[] JRE_Europe_Ulyanovsk = new String[] {
               "Ulyanovsk Standard Time",
               "GMT+04:00",
               "Ulyanovsk Standard Time",
               "GMT+04:00",
               "Ulyanovsk Time",
               "GMT+04:00",
            };
        final String[] Turkmenistan = new String[] {
               "Turkmenistan Standard Time",
               "TMT",
               "Turkmenistan Summer Time",
               "TMST",
               "Turkmenistan Time",
               "TMT",
            };
        final String[] Europe_Western = new String[] {
               "Western European Standard Time",
               "WET",
               "Western European Summer Time",
               "WEST",
               "Western European Time",
               "WET",
            };
        final String[] Guyana = new String[] {
               "Guyana Time",
               "GYT",
               "Guyana Summer Time",
               "GYST",
               "Guyana Time",
               "GYT",
            };
        final String[] Pitcairn = new String[] {
               "Pitcairn Time",
               "PST",
               "Pitcairn Daylight Time",
               "PDT",
               "Pitcairn Time",
               "PT",
            };
        final String[] Rothera = new String[] {
               "Rothera Time",
               "ROTT",
               "Rothera Summer Time",
               "ROTST",
               "Rothera Time",
               "ROTT",
            };
        final String[] Palau = new String[] {
               "Palau Time",
               "PWT",
               "Palau Summer Time",
               "PWST",
               "Palau Time",
               "PWT",
            };
        final String[] Azerbaijan = new String[] {
               "Azerbaijan Standard Time",
               "AZT",
               "Azerbaijan Summer Time",
               "AZST",
               "Azerbaijan Time",
               "AZT",
            };
        final String[] Mawson = new String[] {
               "Mawson Time",
               "MAWT",
               "Mawson Summer Time",
               "MAWST",
               "Mawson Time",
               "MAWT",
            };
        final String[] Mexico_Pacific = new String[] {
               "Mexican Pacific Standard Time",
               "MST",
               "Mexican Pacific Daylight Time",
               "MDT",
               "Mexican Pacific Time",
               "MT",
            };
        final String[] Africa_Western = new String[] {
               "West Africa Standard Time",
               "WAT",
               "West Africa Summer Time",
               "WAST",
               "West Africa Time",
               "WAT",
            };
        final String[] South_Georgia = new String[] {
               "South Georgia Time",
               "GST",
               "South Georgia Daylight Time",
               "GDT",
               "South Georgia Time",
               "GT",
            };
        final String[] JRE_Asia_Istanbul = new String[] {
               "Eastern European Time",
               "EET",
               "Eastern European Summer Time",
               "EEST",
               "Eastern European Time",
               "EET",
            };
        final String[] Mexico_Northwest = new String[] {
               "Northwest Mexico Standard Time",
               "PST",
               "Northwest Mexico Daylight Time",
               "PDT",
               "Northwest Mexico Time",
               "PT",
            };
        final String[] Easter = new String[] {
               "Easter Island Standard Time",
               "EAST",
               "Easter Island Summer Time",
               "EASST",
               "Easter Island Time",
               "EAST",
            };
        final String[] DumontDUrville = new String[] {
               "Dumont-d\u2019Urville Time",
               "DDUT",
               "Dumont-d'Urville Summer Time",
               "DDUST",
               "Dumont-d'Urville Time",
               "DDUT",
            };
        final String[] Greenland_Western = new String[] {
               "West Greenland Standard Time",
               "WGT",
               "West Greenland Summer Time",
               "WGST",
               "West Greenland Time",
               "WGT",
            };
        final String[] Ecuador = new String[] {
               "Ecuador Time",
               "ECT",
               "Ecuador Summer Time",
               "ECST",
               "Ecuador Time",
               "ECT",
            };
        final String[] Gulf = new String[] {
               "Gulf Standard Time",
               "GST",
               "Gulf Daylight Time",
               "GDT",
               "Gulf Time",
               "GT",
            };
        final String[] JRE_WET = new String[] {
               "Western European Time",
               "WET",
               "Western European Summer Time",
               "WEST",
               "Western European Time",
               "WET",
            };
        final String[] Korea = new String[] {
               "Korean Standard Time",
               "KST",
               "Korean Daylight Time",
               "KDT",
               "Korean Time",
               "KT",
            };
        final String[] Australia_Western = new String[] {
               "Australian Western Standard Time",
               "AWST",
               "Australian Western Daylight Time",
               "AWDT",
               "Western Australia Time",
               "AWT",
            };
        final String[] Indonesia_Western = new String[] {
               "Western Indonesia Time",
               "WIB",
               "West Indonesia Summer Time",
               "WIST",
               "West Indonesia Time",
               "WIB",
            };
        final String[] America_Mountain = new String[] {
               "Mountain Standard Time",
               "MST",
               "Mountain Daylight Time",
               "MDT",
               "Mountain Time",
               "MT",
            };
        final String[] Marquesas = new String[] {
               "Marquesas Time",
               "MART",
               "Marquesas Summer Time",
               "MARST",
               "Marquesas Time",
               "MART",
            };
        final String[] Arabian = new String[] {
               "Arabian Standard Time",
               "AST",
               "Arabian Daylight Time",
               "ADT",
               "Arabian Time",
               "AT",
            };
        final String[] Alaska = new String[] {
               "Alaska Standard Time",
               "AKST",
               "Alaska Daylight Time",
               "AKDT",
               "Alaska Time",
               "AKT",
            };
        final String[] Vladivostok = new String[] {
               "Vladivostok Standard Time",
               "VLAT",
               "Vladivostok Summer Time",
               "VLAST",
               "Vladivostok Time",
               "VLAT",
            };
        final String[] Chamorro = new String[] {
               "Chamorro Standard Time",
               "ChST",
               "Chamorro Daylight Time",
               "ChDT",
               "Chamorro Time",
               "ChT",
            };
        final String[] Tokelau = new String[] {
               "Tokelau Time",
               "TKT",
               "Tokelau Summer Time",
               "TKST",
               "Tokelau Time",
               "TKT",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Papua New Guinea Time",
               "PGT",
               "Papua New Guinea Summer Time",
               "PGST",
               "Papua New Guinea Time",
               "PGT",
            };
        final String[] Noronha = new String[] {
               "Fernando de Noronha Standard Time",
               "FNT",
               "Fernando de Noronha Summer Time",
               "FNST",
               "Fernando de Noronha Time",
               "FNT",
            };
        final String[] Brasilia = new String[] {
               "Brasilia Standard Time",
               "BRT",
               "Brasilia Summer Time",
               "BRST",
               "Brasilia Time",
               "BRT",
            };
        final String[] Anadyr = new String[] {
               "Anadyr Standard Time",
               "ANAT",
               "Anadyr Summer Time",
               "ANAST",
               "Anadyr Time",
               "ANAT",
            };
        final String[] Samara = new String[] {
               "Samara Standard Time",
               "SAMT",
               "Samara Summer Time",
               "SAMST",
               "Samara Time",
               "SAMT",
            };
        final String[] Pyongyang = new String[] {
               "Pyongyang Time",
               "KST",
               "Korea Daylight Time",
               "KDT",
               "Korea Time",
               "KT",
            };
        final String[] India = new String[] {
               "India Standard Time",
               "IST",
               "India Daylight Time",
               "IDT",
               "India Time",
               "IT",
            };
        final String[] Cook = new String[] {
               "Cook Islands Standard Time",
               "CKT",
               "Cook Islands Half Summer Time",
               "CKHST",
               "Cook Islands Time",
               "CKT",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu",
                new String[] {
                    "Hawaii Standard Time",
                    "HST",
                    "Hawaii Daylight Time",
                    "HDT",
                    "Hawaii Time",
                    "HST",
                }
            },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC",
                new String[] {
                    "Coordinated Universal Time",
                    "UTC",
                    "Coordinated Universal Time",
                    "UTC",
                    "Coordinated Universal Time",
                    "UTC",
                }
            },
            { "Asia/Aden", Arabian },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "America/El_Salvador", America_Central },
            { "Asia/Pontianak", Indonesia_Western },
            { "Africa/Mbabane", Africa_Southern },
            { "Asia/Kuching", Malaysia },
            { "Europe/London",
                new String[] {
                    "Greenwich Mean Time",
                    "GMT",
                    "British Summer Time",
                    "BST",
                    "British Time",
                    "BT",
                }
            },
            { "America/Panama", America_Eastern },
            { "Asia/Chungking", China },
            { "JST", Japan },
            { "Europe/Jersey", GMT },
            { "Europe/Istanbul", JRE_Europe_Istanbul },
            { "America/Eirunepe", Acre },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Canada/Yukon", America_Pacific },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Tasmania", Australia_Eastern },
            { "Libya", Europe_Eastern },
            { "Europe/Guernsey", GMT },
            { "US/Pacific-New", America_Pacific },
            { "America/Grand_Turk", America_Eastern },
            { "Asia/Samarkand", Uzbekistan },
            { "America/Argentina/Cordoba", Argentina },
            { "Asia/Phnom_Penh", Indochina },
            { "Africa/Kigali", Africa_Central },
            { "BET", JRE_BET },
            { "Cuba", Cuba },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Banjul", GMT },
            { "Antarctica/Syowa", Syowa },
            { "Pacific/Palau", Palau },
            { "America/Montevideo", Uruguay },
            { "Africa/Windhoek", Africa_Central },
            { "Asia/Karachi", Pakistan },
            { "Brazil/East", Brasilia },
            { "Australia/Perth", Australia_Western },
            { "Asia/Chita", Yakutsk },
            { "Pacific/Easter", Easter },
            { "Antarctica/Davis", Davis },
            { "Antarctica/McMurdo", New_Zealand },
            { "America/Argentina/Mendoza", Argentina },
            { "HST",
                new String[] {
                    "Hawaii Standard Time",
                    "HST",
                    "Hawaii Daylight Time",
                    "HDT",
                    "Hawaii Time",
                    "HST",
                }
            },
            { "Pacific/Tahiti", Tahiti },
            { "Africa/Asmera", Africa_Eastern },
            { "Europe/Busingen", Europe_Central },
            { "Africa/Malabo", Africa_Western },
            { "America/Catamarca", Argentina },
            { "America/Godthab", Greenland_Western },
            { "Australia/ACT", Australia_Eastern },
            { "GB-Eire",
                new String[] {
                    "Greenwich Mean Time",
                    "GMT",
                    "British Summer Time",
                    "BST",
                    "British Time",
                    "BT",
                }
            },
            { "Africa/Lagos", Africa_Western },
            { "Europe/Rome", Europe_Central },
            { "Asia/Dacca", Bangladesh },
            { "Indian/Mauritius", Mauritius },
            { "America/Fort_Wayne", America_Eastern },
            { "America/Dawson_Creek", America_Mountain },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "Asia/Dili", East_Timor },
            { "Africa/Bamako", GMT },
            { "GB",
                new String[] {
                    "Greenwich Mean Time",
                    "GMT",
                    "British Summer Time",
                    "BST",
                    "British Time",
                    "BT",
                }
            },
            { "Mexico/General", America_Central },
            { "Pacific/Wallis", Wallis },
            { "Africa/Lubumbashi", Africa_Central },
            { "NZ-CHAT", Chatham },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Omsk", Omsk },
            { "Europe/Vaduz", Europe_Central },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "Pacific/Chatham", Chatham },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Dushanbe", Tajikistan },
            { "America/Guyana", Guyana },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "America/Puerto_Rico", Atlantic },
            { "Pacific/Ponape", Ponape },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Universal",
                new String[] {
                    "Coordinated Universal Time",
                    "UTC",
                    "Coordinated Universal Time",
                    "UTC",
                    "Coordinated Universal Time",
                    "UTC",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Asia/Tel_Aviv", Israel },
            { "America/Cayenne", French_Guiana },
            { "Pacific/Fiji", Fiji },
            { "America/Rainy_River", America_Central },
            { "Indian/Maldives", Maldives },
            { "SystemV/AST4", Atlantic },
            { "Asia/Oral", Kazakhstan_Western },
            { "America/Yellowknife", America_Mountain },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Australia/Victoria", Australia_Eastern },
            { "America/Juneau", Alaska },
            { "America/Indiana/Vevay", America_Eastern },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Barnaul", JRE_Asia_Barnaul },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "America/Noronha", Noronha },
            { "Australia/Adelaide", Australia_Central },
            { "America/Paramaribo", Suriname },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Troll", GMT },
            { "Europe/Samara", Samara },
            { "America/Antigua", Atlantic },
            { "Pacific/Gambier", Gambier },
            { "Africa/Gaborone", Africa_Central },
            { "Asia/Pyongyang", Pyongyang },
            { "Etc/Universal",
                new String[] {
                    "Coordinated Universal Time",
                    "UTC",
                    "Coordinated Universal Time",
                    "UTC",
                    "Coordinated Universal Time",
                    "UTC",
                }
            },
            { "Asia/Gaza", Europe_Eastern },
            { "timezone.excity.Etc/Unknown", "Unknown City" },
            { "Canada/Newfoundland", Newfoundland },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "America/Yakutat", Alaska },
            { "Africa/Asmara", Africa_Eastern },
            { "Europe/Vienna", Europe_Central },
            { "timezone.excity.Europe/Uzhgorod", "Uzhhorod" },
            { "Europe/Tirane", Europe_Central },
            { "Asia/Kolkata", India },
            { "Australia/Canberra", Australia_Eastern },
            { "MET", JRE_MET },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Africa/Abidjan", GMT },
            { "Kwajalein", Marshall_Islands },
            { "America/Santarem", Brasilia },
            { "Asia/Ulan_Bator", Mongolia },
            { "NZ", New_Zealand },
            { "EST5EDT", America_Eastern },
            { "Pacific/Guam", Chamorro },
            { "Atlantic/Bermuda", Atlantic },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "Europe/Amsterdam", Europe_Central },
            { "Africa/Accra", GMT },
            { "Atlantic/Faroe", Europe_Western },
            { "Etc/UCT",
                new String[] {
                    "Coordinated Universal Time",
                    "UTC",
                    "Coordinated Universal Time",
                    "UTC",
                    "Coordinated Universal Time",
                    "UTC",
                }
            },
            { "America/Maceio", Brasilia },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Dublin",
                new String[] {
                    "Greenwich Mean Time",
                    "GMT",
                    "Irish Standard Time",
                    "IST",
                    "Irish Time",
                    "IT",
                }
            },
            { "Pacific/Truk", Truk },
            { "SST", JRE_SST },
            { "America/Jamaica", America_Eastern },
            { "Asia/Bishkek", Kyrgystan },
            { "Atlantic/Stanley", Falkland },
            { "US/Hawaii",
                new String[] {
                    "Hawaii Standard Time",
                    "HST",
                    "Hawaii Daylight Time",
                    "HDT",
                    "Hawaii Time",
                    "HST",
                }
            },
            { "SystemV/CST6", America_Central },
            { "Asia/Vladivostok", Vladivostok },
            { "Africa/Maputo", Africa_Central },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Baghdad", Arabian },
            { "Europe/San_Marino", Europe_Central },
            { "BST", JRE_BST },
            { "America/Indiana/Tell_City", America_Central },
            { "Pacific/Saipan", Chamorro },
            { "timezone.excity.America/Curacao", "Cura\u00e7ao" },
            { "Chile/EasterIsland", Easter },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Damascus", Europe_Eastern },
            { "MIT", JRE_MIT },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/La_Paz", Bolivia },
            { "Asia/Manila", Philippines },
            { "Asia/Bangkok", Indochina },
            { "Poland", Europe_Central },
            { "Atlantic/Madeira", Europe_Western },
            { "America/Thunder_Bay", America_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Punta_Arenas", JRE_America_Punta_Arenas },
            { "America/Mexico_City", America_Central },
            { "Antarctica/Vostok", Vostok },
            { "Europe/Andorra", Europe_Central },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Asia/Riyadh", Arabian },
            { "Europe/Oslo", Europe_Central },
            { "America/Menominee", America_Central },
            { "Europe/Kirov", JRE_Europe_Kirov },
            { "America/Resolute", America_Central },
            { "Africa/Kampala", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "Australia/South", Australia_Central },
            { "Canada/Central", America_Central },
            { "IET", America_Eastern },
            { "Africa/Bujumbura", Africa_Central },
            { "Europe/Minsk", Moscow },
            { "Pacific/Auckland", New_Zealand },
            { "Canada/Eastern", America_Eastern },
            { "Asia/Qatar", Arabian },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Belfast",
                new String[] {
                    "Greenwich Mean Time",
                    "GMT",
                    "British Summer Time",
                    "BST",
                    "British Time",
                    "BT",
                }
            },
            { "America/Port-au-Prince", America_Eastern },
            { "Asia/Ashgabat", Turkmenistan },
            { "America/Nipigon", America_Eastern },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Hermosillo", Mexico_Pacific },
            { "Africa/Maseru", Africa_Southern },
            { "Asia/Kathmandu", Nepal },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Seoul", Korea },
            { "America/Lima", Peru },
            { "Asia/Brunei", Brunei },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "America/Cambridge_Bay", America_Mountain },
            { "Australia/West", Australia_Western },
            { "Asia/Colombo", India },
            { "Indian/Antananarivo", Africa_Eastern },
            { "US/Indiana-Starke", America_Central },
            { "Asia/Urumqi", JRE_Asia_Urumqi },
            { "US/Aleutian", Hawaii_Aleutian },
            { "America/Vancouver", America_Pacific },
            { "Africa/Blantyre", Africa_Central },
            { "America/Detroit", America_Eastern },
            { "America/Thule", Atlantic },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Sakhalin", Sakhalin },
            { "Africa/Harare", Africa_Central },
            { "America/Nome", Alaska },
            { "Europe/Tallinn", Europe_Eastern },
            { "Africa/Johannesburg", Africa_Southern },
            { "EAT", JRE_EAT },
            { "Africa/Bangui", Africa_Western },
            { "Jamaica", America_Eastern },
            { "Europe/Astrakhan", JRE_Europe_Astrakhan },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "Asia/Saigon", Indochina },
            { "Africa/Timbuktu", GMT },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "MST", America_Mountain },
            { "America/Whitehorse", America_Pacific },
            { "Pacific/Noumea", New_Caledonia },
            { "ECT", JRE_ECT },
            { "America/Montreal", America_Eastern },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "Hongkong", Hong_Kong },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "America/Argentina/ComodRivadavia", Argentina },
            { "America/Grenada", Atlantic },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Calcutta", India },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Kabul", Afghanistan },
            { "Indian/Cocos", Cocos },
            { "SystemV/YST9YDT", Alaska },
            { "America/Merida", America_Central },
            { "EET", JRE_EET },
            { "CAT", JRE_CAT },
            { "Canada/Saskatchewan", America_Central },
            { "America/St_Kitts", Atlantic },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Caracas", Venezuela },
            { "Asia/Hebron", Europe_Eastern },
            { "SystemV/PST8PDT", America_Pacific },
            { "Africa/Monrovia", GMT },
            { "Asia/Ust-Nera", Vladivostok },
            { "America/North_Dakota/New_Salem", America_Central },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "America/Shiprock", America_Mountain },
            { "Europe/Vatican", Europe_Central },
            { "timezone.excity.America/Asuncion", "Asunci\u00f3n" },
            { "Asia/Amman", Europe_Eastern },
            { "Etc/UTC",
                new String[] {
                    "Coordinated Universal Time",
                    "UTC",
                    "Coordinated Universal Time",
                    "UTC",
                    "Coordinated Universal Time",
                    "UTC",
                }
            },
            { "Asia/Singapore", Singapore },
            { "SystemV/EST5EDT", America_Eastern },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "Europe/Nicosia", Europe_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Europe/Athens", Europe_Eastern },
            { "US/Pacific", America_Pacific },
            { "Europe/Monaco", Europe_Central },
            { "America/Cuiaba", Amazon },
            { "Africa/Nairobi", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Africa/Cairo", Europe_Eastern },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "America/Belize", America_Central },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Asia/Yerevan", Armenia },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Asia/Kashgar", JRE_Asia_Kashgar },
            { "Chile/Continental", Chile },
            { "Pacific/Yap", Truk },
            { "CET", JRE_CET },
            { "America/Tegucigalpa", America_Central },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Argentina/Catamarca", Argentina },
            { "Canada/Atlantic", Atlantic },
            { "IST", India },
            { "US/Alaska", Alaska },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Asia/Dubai", Gulf },
            { "Europe/Isle_of_Man", GMT },
            { "America/Araguaina", Brasilia },
            { "ACT", JRE_ACT },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Africa/Tunis", Europe_Central },
            { "Pacific/Fakaofo", Tokelau },
            { "Israel", Israel },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "US/Arizona", America_Mountain },
            { "Indian/Reunion", Reunion },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Africa/Mogadishu", Africa_Eastern },
            { "Etc/GMT", GMT },
            { "Asia/Macao", China },
            { "America/Manaus", Amazon },
            { "Africa/Freetown", GMT },
            { "Asia/Tomsk", JRE_Asia_Tomsk },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "AET", JRE_AET },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Sarajevo", Europe_Central },
            { "America/Cordoba", Argentina },
            { "Pacific/Samoa", Samoa },
            { "America/Regina", America_Central },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/Anguilla", Atlantic },
            { "Europe/Saratov", JRE_Europe_Saratov },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Asia/Istanbul", JRE_Asia_Istanbul },
            { "America/Havana", Cuba },
            { "timezone.excity.Africa/Sao_Tome", "S\u00e3o Tom\u00e9" },
            { "America/Porto_Acre", Acre },
            { "AGT", JRE_AGT },
            { "US/Michigan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/Curacao", Atlantic },
            { "Portugal", Europe_Western },
            { "America/Guayaquil", Ecuador },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Rankin_Inlet", America_Central },
            { "America/Argentina/Jujuy", Argentina },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Europe/Zagreb", Europe_Central },
            { "America/Port_of_Spain", Atlantic },
            { "Asia/Beirut", Europe_Eastern },
            { "Pacific/Bougainville", JRE_Pacific_Bougainville },
            { "US/Central", America_Central },
            { "Africa/Sao_Tome", Africa_Western },
            { "Indian/Chagos", Indian_Ocean },
            { "Asia/Yakutsk", Yakutsk },
            { "Pacific/Galapagos", Galapagos },
            { "Australia/North", Australia_Central },
            { "VST", Indochina },
            { "Africa/Ndjamena", Africa_Western },
            { "Australia/Yancowinna", Australia_Central },
            { "CNT", Newfoundland },
            { "Asia/Tashkent", Uzbekistan },
            { "Africa/Ceuta", Europe_Central },
            { "America/Swift_Current", America_Central },
            { "America/Metlakatla", Alaska },
            { "Africa/Djibouti", Africa_Eastern },
            { "EST", America_Eastern },
            { "Europe/Simferopol", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Nouakchott", GMT },
            { "Europe/Prague", Europe_Central },
            { "America/Kralendijk", Atlantic },
            { "Indian/Christmas", Christmas },
            { "NET", JRE_NET },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Pacific/Funafuti", Tuvalu },
            { "Antarctica/Macquarie", Macquarie },
            { "Canada/Pacific", America_Pacific },
            { "America/Moncton", Atlantic },
            { "Pacific/Chuuk", Truk },
            { "America/St_Vincent", Atlantic },
            { "PST8PDT", America_Pacific },
            { "Atlantic/Faeroe", Europe_Western },
            { "America/Kentucky/Louisville", America_Eastern },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Antarctica/Casey", Casey },
            { "Europe/Copenhagen", Europe_Central },
            { "Atlantic/Azores", Azores },
            { "ROK", Korea },
            { "Pacific/Pitcairn", Pitcairn },
            { "Australia/Queensland", Australia_Eastern },
            { "America/Mazatlan", Mexico_Pacific },
            { "Pacific/Nauru", Nauru },
            { "SystemV/MST7", America_Mountain },
            { "America/Dominica", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Asuncion", Paraguay },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "Pacific/Wake", Wake },
            { "Asia/Chongqing", China },
            { "Eire",
                new String[] {
                    "Greenwich Mean Time",
                    "GMT",
                    "Irish Standard Time",
                    "IST",
                    "Irish Time",
                    "IT",
                }
            },
            { "America/Indiana/Knox", America_Central },
            { "timezone.excity.Asia/Saigon", "Ho Chi Minh City" },
            { "PLT", JRE_PLT },
            { "America/North_Dakota/Beulah", America_Central },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Apia", Apia },
            { "America/Atka", Hawaii_Aleutian },
            { "Pacific/Niue", Niue },
            { "CST", America_Central },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Atikokan", America_Eastern },
            { "Australia/NSW", Australia_Eastern },
            { "Indian/Mahe", Seychelles },
            { "CTT", China },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Africa/Libreville", Africa_Western },
            { "Zulu",
                new String[] {
                    "Coordinated Universal Time",
                    "UTC",
                    "Coordinated Universal Time",
                    "UTC",
                    "Coordinated Universal Time",
                    "UTC",
                }
            },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/Coral_Harbour", America_Eastern },
            { "Pacific/Marquesas", Marquesas },
            { "Brazil/West", Amazon },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "PNT", America_Mountain },
            { "America/Tijuana", America_Pacific },
            { "SystemV/YST9", Gambier },
            { "Africa/Douala", Africa_Western },
            { "America/Chihuahua", Mexico_Pacific },
            { "America/Ojinaga", America_Mountain },
            { "Asia/Hovd", Hovd },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "America/Santiago", Chile },
            { "Asia/Baku", Azerbaijan },
            { "ART", JRE_ART },
            { "America/Argentina/Ushuaia", Argentina },
            { "Atlantic/Reykjavik", GMT },
            { "Africa/Brazzaville", Africa_Western },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "Asia/Taipei", Taipei },
            { "Antarctica/South_Pole", New_Zealand },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Antarctica/Palmer", JRE_Antarctica_Palmer },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "AST", Alaska },
            { "Asia/Yangon", Myanmar },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Etc/Zulu",
                new String[] {
                    "Coordinated Universal Time",
                    "UTC",
                    "Coordinated Universal Time",
                    "UTC",
                    "Coordinated Universal Time",
                    "UTC",
                }
            },
            { "America/Creston", America_Mountain },
            { "US/Samoa", Samoa },
            { "PRC", China },
            { "Asia/Vientiane", Indochina },
            { "Pacific/Kiritimati", Line_Islands },
            { "Iceland", GMT },
            { "Pacific/Pohnpei", Ponape },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Europe/Lisbon", Europe_Western },
            { "Asia/Harbin", China },
            { "PRT", Atlantic },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "America/Knox_IN", America_Central },
            { "SystemV/HST10",
                new String[] {
                    "Hawaii Standard Time",
                    "HST",
                    "Hawaii Daylight Time",
                    "HDT",
                    "Hawaii Time",
                    "HST",
                }
            },
            { "Asia/Kuwait", Arabian },
            { "Pacific/Efate", Vanuatu },
            { "Africa/Lome", GMT },
            { "America/Bogota", Colombia },
            { "America/Adak", Hawaii_Aleutian },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "Greenwich", GMT },
            { "PST", America_Pacific },
            { "SystemV/EST5", America_Eastern },
            { "America/Santo_Domingo", Atlantic },
            { "US/Eastern", America_Eastern },
            { "America/Glace_Bay", Atlantic },
            { "Singapore", Singapore },
            { "SystemV/PST8", Pitcairn },
            { "Asia/Magadan", Magadan },
            { "America/St_Barthelemy", Atlantic },
            { "Africa/Luanda", Africa_Western },
            { "timezone.excity.America/St_Barthelemy", "St. Barth\u00e9lemy" },
            { "Brazil/Acre", Acre },
            { "Asia/Muscat", Gulf },
            { "Asia/Bahrain", Arabian },
            { "Europe/Vilnius", Europe_Eastern },
            { "US/East-Indiana", America_Eastern },
            { "America/Cancun", America_Eastern },
            { "Pacific/Kosrae", Kosrae },
            { "Australia/Sydney", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Europe/Volgograd", Moscow },
            { "America/Lower_Princes", Atlantic },
            { "America/Rio_Branco", Acre },
            { "America/Danmarkshavn", GMT },
            { "Africa/Lusaka", Africa_Central },
            { "Iran", Iran },
            { "America/Argentina/La_Rioja", Argentina },
            { "SystemV/CST6CDT", America_Central },
            { "Africa/Dakar", GMT },
            { "America/Tortola", Atlantic },
            { "America/Porto_Velho", Amazon },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Kamchatka", Kamchatka },
            { "Navajo", America_Mountain },
            { "NST", New_Zealand },
            { "Turkey", JRE_Turkey },
            { "Africa/Khartoum", Africa_Central },
            { "Europe/Belgrade", Europe_Central },
            { "Africa/Bissau", GMT },
            { "Asia/Tehran", Iran },
            { "WET", JRE_WET },
            { "Etc/Greenwich", GMT },
            { "America/Ensenada", America_Pacific },
            { "Pacific/Midway", Samoa },
            { "America/Jujuy", Argentina },
            { "America/Virgin", Atlantic },
            { "America/Pangnirtung", America_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Africa/Niamey", Africa_Western },
            { "Asia/Tbilisi", Georgia },
            { "UCT",
                new String[] {
                    "Coordinated Universal Time",
                    "UTC",
                    "Coordinated Universal Time",
                    "UTC",
                    "Coordinated Universal Time",
                    "UTC",
                }
            },
            { "timezone.excity.Indian/Reunion", "R\u00e9union" },
            { "America/Boa_Vista", Amazon },
            { "Asia/Atyrau", Kazakhstan_Western },
            { "Australia/Darwin", Australia_Central },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Famagusta", JRE_Asia_Famagusta },
            { "Europe/Bratislava", Europe_Central },
            { "Japan", Japan },
            { "Pacific/Tongatapu", Tonga },
            { "Europe/Ulyanovsk", JRE_Europe_Ulyanovsk },
            { "W-SU", Moscow },
            { "America/Rosario", Argentina },
            { "Arctic/Longyearbyen", Europe_Central },
            { "America/Guadeloupe", Atlantic },
            { "Indian/Kerguelen", French_Southern },
            { "Egypt", Europe_Eastern },
            { "Asia/Srednekolymsk", JRE_Asia_Srednekolymsk },
            { "Asia/Anadyr", Anadyr },
            { "America/Winnipeg", America_Central },
            { "SystemV/AST4ADT", Atlantic },
            { "America/Toronto", America_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Pacific/Majuro", Marshall_Islands },
        };
        return data;
    }
}
