#!/usr/bin/python3
# -*- coding: utf-8 -*-

######################################################################
# Pour diversifier les jeux de données, 
# 1 - placer ce script dans le dossier des SIP à traiter
# 2 - Modifier la configuration ci après pour changer le nom d'utilisateur, les extensions à traiter ou la liste des balises à modifier
# 3 - Lancer le script pour traiter tous les SIP dans le répertoire courant OU lancer le script avec des arguments pour ne modifier que ces SIPs là OU glisser déposer les SIP à modifier sur le fichier diversificationSIP.desktop (Linux)
# Si les données à diversifier ne sont pas au format zip,
# changer la variable "extension" en conséquence
######################################################################


###################
## CONFIGURATION ##
###################

#Nom qui sera ajouté au SIP, pensez à laisser un espace avant le nom pour faciliter la recherche
user = " PPAVY"

# Extension des fichiers à traiter
extension = ".zip"

#Liste des balises à modifier
strXMLTag = ["MessageIdentifier", "Comment", "Title"]





#####################
## DEBUT DU SCRIPT ##
#####################


import zipfile
import os
import time
import shutil
import re
import sys

# Cette fonction prend en entrée 
# strXMLTag : la balise XML dont le contenu doit être changé (il sera changé pour toutes ces balises)
# stream : l'ensemble du bordereau
# Et retourne le stream modifié pour cette balise
def replace(strXMLTag, stream):
	y = re.findall("<"+strXMLTag+">(.+?)</"+strXMLTag+">",stream)
	for Replacement in range(0,len(y)) :	
		regexThisUnit = "<"+strXMLTag+">"+y[Replacement]+"</"+strXMLTag+">"
		regexThisUnit= re.escape(regexThisUnit)
		stream = re.sub(regexThisUnit,"<"+strXMLTag+">"+y[Replacement]+ext+"</"+strXMLTag+">",stream)
	return stream;

#global ext
ext = user+str(time.strftime("%d%H%M"))

#extraction du zip et modification du xml
fileList = []

# Si le script n'a aucun argument, alors tous les fichiers du dossier, ayant la bonne extension, sont traités
# Si le script a plusieurs argument, ces arguments doivent être des fichiers. Ces fichiers seront traités. 
# On construit la liste des fichiers à traiter dans "fileList"
if (len(sys.argv) == 1):
	i=0
	for file in os.listdir('.') :
		if file.endswith(extension) :
			fileList.append((file))
			i=i+1
else:
	for nbArg in range (1,len(sys.argv)):
		fileList.append(sys.argv[nbArg])		

# Pour chaque fichier, on effectue l'ensemble du traitement
for i in range(0,len(fileList)):

#extraction du zip
	SIPName = os.path.splitext(os.path.basename(fileList[i]))[0]
	SIP = zipfile.ZipFile(fileList[i], 'r')
	SIP.extractall(SIPName)
	SIP.close()

#Lecture du XML
	fileName = SIPName+"/manifest.xml"
	print(fileName)
	xml = open(fileName,"r")
	stream = xml.read()
	xml.close()

#modification des données : MessageIdentifier, comment, title des units
	toChange=0		
	while toChange < len(strXMLTag) :
		stream = replace(strXMLTag[toChange],stream)
		toChange+=1

#Ecriture du XML
	xml = open(fileName,"w")
	xml.write(stream)
	xml.close()

#Creation de la nouvelle archive
	shutil.make_archive(SIPName+ext, "zip", SIPName)
	print ("fichier "+SIPName+ext+extension+" créé avec succès")		

#Suppression du dossier et de l'ancienne archive
	shutil.rmtree(SIPName)
	os.remove(fileList[i])
	print ("fichier "+SIPName+extension+" supprimé")












